/**
 * Cookie according to RFC 9110
 */
class Cookie {
	Str name;
	Str value;
	Str path = "";	  // Change to URL?
	Str domain ="";
	Str expires ="";	// Maybe add a time class? There is one in Storm already but too basic
	Nat maxAge = 0;
	Bool secure = false;
	Bool httpOnly = false;
	Str sameSite ="";
	Bool cookieValid = true;


	void toS(StrBuf to) : override {
		to << name << "=" << value;
		if (path != "")
			to << "; Path=" << path;
		if (domain != "")
			to << "; Domain=" << domain;
		if (expires != "")
			to << "; Expires=" << expires;
		if (maxAge != 0)
			to << "; Max-Age: " << maxAge;
		if (secure)
			to << "; Secure";
		if (httpOnly)
			to << "; HttpOnly";
		if (sameSite != "")
			to << "; SamSite=" << sameSite;
	}

}

// TODO: It does not seem like this is used.
Bool responseCookieParser(Cookie cookie) on Compiler {
	initMonth();	  //Call in server
	initDays();		  //Call in server
	Str:Iter iter;
	if (cookie.name != "") {
		cookie.name = cookie.name;
	} else {
		return false;
	}
	if (cookie.value != "") {
		//parse here if string in ascii US
		iter = cookie.value.find(' ', cookie.value.begin());
		if (iter != cookie.value.end())
			return false;
		iter = cookie.value.find(',' , cookie.value.begin());
		if (iter != cookie.value.end())
			return false;
		iter = cookie.value.find(';' , cookie.value.begin());
		if (iter != cookie.value.end())
			return false;
	} else {
		return false;
	}
	if (cookie.path != "") {
		iter = cookie.path.find(';', cookie.path.begin());
		if (iter != cookie.path.end())
			return false;
		//parse here
	}
	if (cookie.domain != "") {
		//Should be subdomain ?
		// parse here
		// cookie.domain = trimWhitespace(cookie.domain);
	}
	if (cookie.expires != "") {
		StrBuf buf;
		iter = cookie.expires.find(' ', cookie.expires.begin());
		buf << cookie.expires.cut(cookie.expires.begin(), iter);
		Str:Iter iter2;
		for(Int i = 0; i < 4; i++) {
			if (iter == cookie.expires.end())
				return false;
			iter2 = iter + 1;
			iter = cookie.expires.find(' ', iter2);
			buf << cookie.expires.cut(iter2, iter);
		}
		Str cookiestr = buf.toS();
		// print("\n\n"+cookiestr+"\n\n");
		if (cookiestr.count() != 24) {
			return false;
		}
		if ("," != cookiestr.cut(cookiestr.begin()+3, cookiestr.begin()+4))
			return false;
		iter = cookiestr.begin()+3;
		if (!dayFormatIMF.has(cookiestr.cut(cookiestr.begin(), iter))) {
			return false;
		}

		Str month = cookiestr.cut(iter+3, iter+6);
		if (!monthFormatIMF.has(month)) {
			return false;
		}
		Str day = cookiestr.cut(iter+1, iter+3);
		if (val = day.int) {
			if (val < 1 | val > monthFormatIMF.get(month))	//Check if day is correct in month
				return false;
		} else {
			return false;
		}

		Str year = cookiestr.cut(iter+6, iter+10);
		if (val = year.int) {
			if (val < 1970)
				return false;
		} else {
			return false;
		}

		Str hour = cookiestr.cut(iter+10, iter+12);
		if (val = hour.int) {
			if (val < 0 | val > 23)
				return false;
		} else {
			return false;
		}

		if (cookiestr.cut(iter+12, iter+13) != ":" | cookiestr.cut(iter+15, iter+16) != ":" )
			return false;

		Str minute = cookiestr.cut(iter+13, iter+15);
		if (val = minute.int) {
			if (val < 0 | val > 59)
				return false;
		} else {
			return false;
		}

		Str second = cookiestr.cut(iter+16, iter+18);
		if (val = second.int) {
			if (val < 0 | val > 60)
				return false;
		} else {
			return false;
		}

		if (cookiestr.cut(iter+18, cookiestr.end()) != "GMT")
			return false;

		//parse here
	}
	if (cookie.sameSite != "") {
		if (cookie.sameSite != "None")
			if (cookie.sameSite != "Lax")
				if (cookie.sameSite != "Strict")
					return false;
	}

	return true;
}
