; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu -O2 \
; RUN:     -ppc-asm-full-reg-names -mcpu=pwr10 < %s | FileCheck %s \
; RUN:     --check-prefixes=CHECK,CHECK-LE
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu -O2 \
; RUN:     -ppc-asm-full-reg-names -mcpu=pwr10 < %s | FileCheck %s \
; RUN:     --check-prefixes=CHECK,CHECK-BE

; This file does not contain many test cases involving comparisons and logical
; comparisons (cmplwi, cmpldi). This is because alternative code is generated
; when there is a compare (logical or not), followed by a sign or zero extend.
; This codegen will be re-evaluated at a later time on whether or not it should
; be emitted on P10.

@globalVal = common dso_local local_unnamed_addr global i8 0, align 1
@globalVal2 = common dso_local local_unnamed_addr global i32 0, align 4
@globalVal3 = common dso_local local_unnamed_addr global i64 0, align 8
@globalVal4 = common dso_local local_unnamed_addr global i16 0, align 2

define dso_local signext i32 @setnbcr1(i8 %a) {
; CHECK-LABEL: setnbcr1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi. r3, r3, 255
; CHECK-NEXT:    setnbcr r3, eq
; CHECK-NEXT:    blr
entry:
  %cmp = icmp uge i8 %a, 1
  %conv = sext i1 %cmp to i32
  ret i32 %conv
}

define dso_local signext i32 @setnbcr2(i32 %a) {
; CHECK-LABEL: setnbcr2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpwi r3, 0
; CHECK-NEXT:    setnbcr r3, eq
; CHECK-NEXT:    blr
entry:
  %cmp = icmp uge i32 %a, 1
  %conv = sext i1 %cmp to i32
  ret i32 %conv
}

define dso_local signext i32 @setnbcr3(i64 %a) {
; CHECK-LABEL: setnbcr3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpdi r3, 0
; CHECK-NEXT:    setnbcr r3, eq
; CHECK-NEXT:    blr
entry:
  %cmp = icmp uge i64 %a, 1
  %conv = sext i1 %cmp to i32
  ret i32 %conv
}

define dso_local signext i32 @setnbcr4(i16 %a) {
; CHECK-LABEL: setnbcr4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi. r3, r3, 65535
; CHECK-NEXT:    setnbcr r3, eq
; CHECK-NEXT:    blr
entry:
  %cmp = icmp uge i16 %a, 1
  %conv = sext i1 %cmp to i32
  ret i32 %conv
}

define signext i64 @setnbcr5(i8 %a) {
; CHECK-LABEL: setnbcr5:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi. r3, r3, 255
; CHECK-NEXT:    setnbcr r3, eq
; CHECK-NEXT:    blr
entry:
  %cmp = icmp uge i8 %a, 1
  %conv = sext i1 %cmp to i64
  ret i64 %conv
}

define signext i64 @setnbcr6(i32 %a) {
; CHECK-LABEL: setnbcr6:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpwi r3, 0
; CHECK-NEXT:    setnbcr r3, eq
; CHECK-NEXT:    blr
entry:
  %cmp = icmp uge i32 %a, 1
  %conv = sext i1 %cmp to i64
  ret i64 %conv
}

define signext i64 @setnbcr7(i64 %a) {
; CHECK-LABEL: setnbcr7:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpdi r3, 0
; CHECK-NEXT:    setnbcr r3, eq
; CHECK-NEXT:    blr
entry:
  %cmp = icmp uge i64 %a, 1
  %conv = sext i1 %cmp to i64
  ret i64 %conv
}

define signext i64 @setnbcr8(i16 %a) {
; CHECK-LABEL: setnbcr8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andi. r3, r3, 65535
; CHECK-NEXT:    setnbcr r3, eq
; CHECK-NEXT:    blr
entry:
  %cmp = icmp uge i16 %a, 1
  %conv = sext i1 %cmp to i64
  ret i64 %conv
}

define dso_local void @setnbcr9(i8 %a) {
; CHECK-LE-LABEL: setnbcr9:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    andi. r3, r3, 255
; CHECK-LE-NEXT:    setnbcr r3, eq
; CHECK-LE-NEXT:    pstb r3, globalVal@PCREL(0), 1
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: setnbcr9:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    andi. r3, r3, 255
; CHECK-BE-NEXT:    addis r4, r2, globalVal@toc@ha
; CHECK-BE-NEXT:    setnbcr r3, eq
; CHECK-BE-NEXT:    stb r3, globalVal@toc@l(r4)
; CHECK-BE-NEXT:    blr
entry:
  %cmp = icmp uge i8 %a, 1
  %conv1 = sext i1 %cmp to i8
  store i8 %conv1, ptr @globalVal, align 1
  ret void
}

define dso_local void @setnbcr10(i32 %a) {
; CHECK-LE-LABEL: setnbcr10:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    cmpwi r3, 0
; CHECK-LE-NEXT:    setnbcr r3, eq
; CHECK-LE-NEXT:    pstw r3, globalVal2@PCREL(0), 1
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: setnbcr10:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    cmpwi r3, 0
; CHECK-BE-NEXT:    addis r4, r2, globalVal2@toc@ha
; CHECK-BE-NEXT:    setnbcr r3, eq
; CHECK-BE-NEXT:    stw r3, globalVal2@toc@l(r4)
; CHECK-BE-NEXT:    blr
entry:
  %cmp = icmp uge i32 %a, 1
  %conv1 = sext i1 %cmp to i32
  store i32 %conv1, ptr @globalVal2, align 4
  ret void
}

define dso_local void @setnbcr11(i64 %a) {
; CHECK-LE-LABEL: setnbcr11:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    cmpdi r3, 0
; CHECK-LE-NEXT:    setnbcr r3, eq
; CHECK-LE-NEXT:    pstd r3, globalVal3@PCREL(0), 1
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: setnbcr11:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    cmpdi r3, 0
; CHECK-BE-NEXT:    addis r4, r2, globalVal3@toc@ha
; CHECK-BE-NEXT:    setnbcr r3, eq
; CHECK-BE-NEXT:    std r3, globalVal3@toc@l(r4)
; CHECK-BE-NEXT:    blr
entry:
  %cmp = icmp uge i64 %a, 1
  %conv1 = sext i1 %cmp to i64
  store i64 %conv1, ptr @globalVal3, align 8
  ret void
}

define dso_local void @setnbcr12(i16 %a) {
; CHECK-LE-LABEL: setnbcr12:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    andi. r3, r3, 65535
; CHECK-LE-NEXT:    setnbcr r3, eq
; CHECK-LE-NEXT:    psth r3, globalVal4@PCREL(0), 1
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: setnbcr12:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    andi. r3, r3, 65535
; CHECK-BE-NEXT:    addis r4, r2, globalVal4@toc@ha
; CHECK-BE-NEXT:    setnbcr r3, eq
; CHECK-BE-NEXT:    sth r3, globalVal4@toc@l(r4)
; CHECK-BE-NEXT:    blr
entry:
  %cmp = icmp uge i16 %a, 1
  %conv1 = sext i1 %cmp to i16
  store i16 %conv1, ptr @globalVal4, align 2
  ret void
}

define dso_local signext i32 @setnbcr13(i8 %a) {
; CHECK-LABEL: setnbcr13:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    clrlwi r3, r3, 24
; CHECK-NEXT:    cmpwi r3, 1
; CHECK-NEXT:    setnbcr r3, eq
; CHECK-NEXT:    blr
entry:
  %cmp = icmp ne i8 %a, 1
  %conv = sext i1 %cmp to i32
  ret i32 %conv
}

define dso_local signext i32 @setnbcr14(i32 %a) {
; CHECK-LABEL: setnbcr14:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpwi r3, 1
; CHECK-NEXT:    setnbcr r3, eq
; CHECK-NEXT:    blr
entry:
  %cmp = icmp ne i32 %a, 1
  %conv = sext i1 %cmp to i32
  ret i32 %conv
}

define dso_local signext i32 @setnbcr15(i64 %a) {
; CHECK-LABEL: setnbcr15:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpdi r3, 1
; CHECK-NEXT:    setnbcr r3, eq
; CHECK-NEXT:    blr
entry:
  %cmp = icmp ne i64 %a, 1
  %conv = sext i1 %cmp to i32
  ret i32 %conv
}

define dso_local signext i32 @setnbcr16(i16 %a) {
; CHECK-LABEL: setnbcr16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    clrlwi r3, r3, 16
; CHECK-NEXT:    cmpwi r3, 1
; CHECK-NEXT:    setnbcr r3, eq
; CHECK-NEXT:    blr
entry:
  %cmp = icmp ne i16 %a, 1
  %conv = sext i1 %cmp to i32
  ret i32 %conv
}

define signext i64 @setnbcr17(i8 %a) {
; CHECK-LABEL: setnbcr17:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    clrlwi r3, r3, 24
; CHECK-NEXT:    cmpwi r3, 1
; CHECK-NEXT:    setnbcr r3, eq
; CHECK-NEXT:    blr
entry:
  %cmp = icmp ne i8 %a, 1
  %conv = sext i1 %cmp to i64
  ret i64 %conv
}

define signext i64 @setnbcr18(i32 %a) {
; CHECK-LABEL: setnbcr18:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpwi r3, 1
; CHECK-NEXT:    setnbcr r3, eq
; CHECK-NEXT:    blr
entry:
  %cmp = icmp ne i32 %a, 1
  %conv = sext i1 %cmp to i64
  ret i64 %conv
}

define signext i64 @setnbcr19(i64 %a) {
; CHECK-LABEL: setnbcr19:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cmpdi r3, 1
; CHECK-NEXT:    setnbcr r3, eq
; CHECK-NEXT:    blr
entry:
  %cmp = icmp ne i64 %a, 1
  %conv = sext i1 %cmp to i64
  ret i64 %conv
}

define signext i64 @setnbcr20(i16 %a) {
; CHECK-LABEL: setnbcr20:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    clrlwi r3, r3, 16
; CHECK-NEXT:    cmpwi r3, 1
; CHECK-NEXT:    setnbcr r3, eq
; CHECK-NEXT:    blr
entry:
  %cmp = icmp ne i16 %a, 1
  %conv = sext i1 %cmp to i64
  ret i64 %conv
}

define dso_local void @setnbcr21(i8 %a) {
; CHECK-LE-LABEL: setnbcr21:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    clrlwi r3, r3, 24
; CHECK-LE-NEXT:    cmpwi r3, 1
; CHECK-LE-NEXT:    setnbcr r3, eq
; CHECK-LE-NEXT:    pstb r3, globalVal@PCREL(0), 1
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: setnbcr21:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    clrlwi r3, r3, 24
; CHECK-BE-NEXT:    addis r4, r2, globalVal@toc@ha
; CHECK-BE-NEXT:    cmpwi r3, 1
; CHECK-BE-NEXT:    setnbcr r3, eq
; CHECK-BE-NEXT:    stb r3, globalVal@toc@l(r4)
; CHECK-BE-NEXT:    blr
entry:
  %cmp = icmp ne i8 %a, 1
  %conv1 = sext i1 %cmp to i8
  store i8 %conv1, ptr @globalVal, align 1
  ret void
}

define dso_local void @setnbcr22(i32 %a) {
; CHECK-LE-LABEL: setnbcr22:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    cmpwi r3, 1
; CHECK-LE-NEXT:    setnbcr r3, eq
; CHECK-LE-NEXT:    pstw r3, globalVal2@PCREL(0), 1
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: setnbcr22:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    cmpwi r3, 1
; CHECK-BE-NEXT:    addis r4, r2, globalVal2@toc@ha
; CHECK-BE-NEXT:    setnbcr r3, eq
; CHECK-BE-NEXT:    stw r3, globalVal2@toc@l(r4)
; CHECK-BE-NEXT:    blr
entry:
  %cmp = icmp ne i32 %a, 1
  %conv1 = sext i1 %cmp to i32
  store i32 %conv1, ptr @globalVal2, align 4
  ret void
}

define dso_local void @setnbcr23(i64 %a) {
; CHECK-LE-LABEL: setnbcr23:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    cmpdi r3, 1
; CHECK-LE-NEXT:    setnbcr r3, eq
; CHECK-LE-NEXT:    pstd r3, globalVal3@PCREL(0), 1
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: setnbcr23:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    cmpdi r3, 1
; CHECK-BE-NEXT:    addis r4, r2, globalVal3@toc@ha
; CHECK-BE-NEXT:    setnbcr r3, eq
; CHECK-BE-NEXT:    std r3, globalVal3@toc@l(r4)
; CHECK-BE-NEXT:    blr
entry:
  %cmp = icmp ne i64 %a, 1
  %conv1 = sext i1 %cmp to i64
  store i64 %conv1, ptr @globalVal3, align 8
  ret void
}

define dso_local void @setnbcr24(i16 %a) {
; CHECK-LE-LABEL: setnbcr24:
; CHECK-LE:       # %bb.0: # %entry
; CHECK-LE-NEXT:    clrlwi r3, r3, 16
; CHECK-LE-NEXT:    cmpwi r3, 1
; CHECK-LE-NEXT:    setnbcr r3, eq
; CHECK-LE-NEXT:    psth r3, globalVal4@PCREL(0), 1
; CHECK-LE-NEXT:    blr
;
; CHECK-BE-LABEL: setnbcr24:
; CHECK-BE:       # %bb.0: # %entry
; CHECK-BE-NEXT:    clrlwi r3, r3, 16
; CHECK-BE-NEXT:    addis r4, r2, globalVal4@toc@ha
; CHECK-BE-NEXT:    cmpwi r3, 1
; CHECK-BE-NEXT:    setnbcr r3, eq
; CHECK-BE-NEXT:    sth r3, globalVal4@toc@l(r4)
; CHECK-BE-NEXT:    blr
entry:
  %cmp = icmp ne i16 %a, 1
  %conv1 = sext i1 %cmp to i16
  store i16 %conv1, ptr @globalVal4, align 2
  ret void
}

