// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright (C) 2025 MediaTek Inc.
 * Author: Guodong Liu <Guodong.Liu@mediatek.com>
 *         Lei Xue <lei.xue@mediatek.com>
 *         Cathy Xu <ot_cathy.xu@mediatek.com>
 */

#include <linux/module.h>
#include "pinctrl-mtk-mt8196.h"
#include "pinctrl-paris.h"

#define PIN_FIELD_BASE(s_pin, e_pin, i_base, s_addr, x_addrs, s_bit, x_bits)  \
	PIN_FIELD_CALC(s_pin, e_pin, i_base, s_addr, x_addrs, s_bit, x_bits, \
		32, 0)

#define PINS_FIELD_BASE(s_pin, e_pin, i_base, s_addr, x_addrs, s_bit, x_bits) \
	PIN_FIELD_CALC(s_pin, e_pin, i_base, s_addr, x_addrs, s_bit, x_bits, \
		32, 1)

static const struct mtk_pin_field_calc mt8196_pin_mode_range[] = {
	PIN_FIELD(0, 270, 0x0300, 0x10, 0, 4),
};

static const struct mtk_pin_field_calc mt8196_pin_dir_range[] = {
	PIN_FIELD(0, 270, 0x0000, 0x10, 0, 1),
};

static const struct mtk_pin_field_calc mt8196_pin_di_range[] = {
	PIN_FIELD(0, 270, 0x0200, 0x10, 0, 1),
};

static const struct mtk_pin_field_calc mt8196_pin_do_range[] = {
	PIN_FIELD(0, 270, 0x0100, 0x10, 0, 1),
};

static const struct mtk_pin_field_calc mt8196_pin_smt_range[] = {
	PIN_FIELD_BASE(0, 0, 8, 0x00d0, 0x10, 0, 1),
	PIN_FIELD_BASE(1, 1, 8, 0x00d0, 0x10, 1, 1),
	PIN_FIELD_BASE(2, 2, 11, 0x00a0, 0x10, 1, 1),
	PIN_FIELD_BASE(3, 3, 11, 0x00a0, 0x10, 1, 1),
	PIN_FIELD_BASE(4, 4, 11, 0x00a0, 0x10, 2, 1),
	PIN_FIELD_BASE(5, 5, 11, 0x00a0, 0x10, 2, 1),
	PIN_FIELD_BASE(6, 6, 11, 0x00a0, 0x10, 2, 1),
	PIN_FIELD_BASE(7, 7, 11, 0x00a0, 0x10, 2, 1),
	PIN_FIELD_BASE(8, 8, 11, 0x00a0, 0x10, 3, 1),
	PIN_FIELD_BASE(9, 9, 9, 0x0120, 0x10, 13, 1),
	PIN_FIELD_BASE(10, 10, 9, 0x0120, 0x10, 12, 1),
	PIN_FIELD_BASE(11, 11, 8, 0x00d0, 0x10, 2, 1),
	PIN_FIELD_BASE(12, 12, 9, 0x0120, 0x10, 15, 1),
	PIN_FIELD_BASE(13, 13, 6, 0x0120, 0x10, 3, 1),
	PIN_FIELD_BASE(14, 14, 3, 0x00c0, 0x10, 0, 1),
	PIN_FIELD_BASE(15, 15, 6, 0x0120, 0x10, 0, 1),
	PIN_FIELD_BASE(16, 16, 6, 0x0120, 0x10, 3, 1),
	PIN_FIELD_BASE(17, 17, 6, 0x0120, 0x10, 3, 1),
	PIN_FIELD_BASE(18, 18, 6, 0x0120, 0x10, 1, 1),
	PIN_FIELD_BASE(19, 19, 6, 0x0120, 0x10, 2, 1),
	PIN_FIELD_BASE(20, 20, 3, 0x00c0, 0x10, 4, 1),
	PIN_FIELD_BASE(21, 21, 2, 0x00b0, 0x10, 0, 1),
	PIN_FIELD_BASE(22, 22, 2, 0x00b0, 0x10, 1, 1),
	PIN_FIELD_BASE(23, 23, 2, 0x00b0, 0x10, 2, 1),
	PIN_FIELD_BASE(24, 24, 2, 0x00b0, 0x10, 3, 1),
	PIN_FIELD_BASE(25, 25, 2, 0x00b0, 0x10, 4, 1),
	PIN_FIELD_BASE(26, 26, 2, 0x00b0, 0x10, 5, 1),
	PIN_FIELD_BASE(27, 27, 2, 0x00b0, 0x10, 7, 1),
	PIN_FIELD_BASE(28, 28, 2, 0x00b0, 0x10, 7, 1),
	PIN_FIELD_BASE(29, 29, 2, 0x00b0, 0x10, 7, 1),
	PIN_FIELD_BASE(30, 30, 2, 0x00b0, 0x10, 8, 1),
	PIN_FIELD_BASE(31, 31, 2, 0x00b0, 0x10, 8, 1),
	PIN_FIELD_BASE(32, 32, 1, 0x00c0, 0x10, 8, 1),
	PIN_FIELD_BASE(33, 33, 1, 0x00c0, 0x10, 8, 1),
	PIN_FIELD_BASE(34, 34, 1, 0x00c0, 0x10, 8, 1),
	PIN_FIELD_BASE(35, 35, 1, 0x00c0, 0x10, 8, 1),
	PIN_FIELD_BASE(36, 36, 1, 0x00c0, 0x10, 9, 1),
	PIN_FIELD_BASE(37, 37, 1, 0x00c0, 0x10, 9, 1),
	PIN_FIELD_BASE(38, 38, 1, 0x00c0, 0x10, 6, 1),
	PIN_FIELD_BASE(39, 39, 8, 0x00d0, 0x10, 4, 1),
	PIN_FIELD_BASE(40, 40, 8, 0x00d0, 0x10, 3, 1),
	PIN_FIELD_BASE(41, 41, 8, 0x00d0, 0x10, 3, 1),
	PIN_FIELD_BASE(42, 42, 8, 0x00d0, 0x10, 3, 1),
	PIN_FIELD_BASE(43, 43, 8, 0x00d0, 0x10, 3, 1),
	PIN_FIELD_BASE(44, 44, 8, 0x00d0, 0x10, 5, 1),
	PIN_FIELD_BASE(45, 45, 8, 0x00d0, 0x10, 5, 1),
	PIN_FIELD_BASE(46, 46, 8, 0x00d0, 0x10, 6, 1),
	PIN_FIELD_BASE(47, 47, 8, 0x00d0, 0x10, 9, 1),
	PIN_FIELD_BASE(48, 48, 8, 0x00d0, 0x10, 7, 1),
	PIN_FIELD_BASE(49, 49, 8, 0x00d0, 0x10, 10, 1),
	PIN_FIELD_BASE(50, 50, 8, 0x00d0, 0x10, 8, 1),
	PIN_FIELD_BASE(51, 51, 8, 0x00d0, 0x10, 11, 1),
	PIN_FIELD_BASE(52, 52, 9, 0x0120, 0x10, 7, 1),
	PIN_FIELD_BASE(53, 53, 9, 0x0120, 0x10, 8, 1),
	PIN_FIELD_BASE(54, 54, 9, 0x0120, 0x10, 2, 1),
	PIN_FIELD_BASE(55, 55, 9, 0x0120, 0x10, 1, 1),
	PIN_FIELD_BASE(56, 56, 9, 0x0120, 0x10, 5, 1),
	PIN_FIELD_BASE(57, 57, 9, 0x0120, 0x10, 6, 1),
	PIN_FIELD_BASE(58, 58, 9, 0x0120, 0x10, 3, 1),
	PIN_FIELD_BASE(59, 59, 9, 0x0120, 0x10, 4, 1),
	PIN_FIELD_BASE(60, 60, 9, 0x0120, 0x10, 19, 1),
	PIN_FIELD_BASE(61, 61, 9, 0x0120, 0x10, 10, 1),
	PIN_FIELD_BASE(62, 62, 9, 0x0120, 0x10, 9, 1),
	PIN_FIELD_BASE(63, 63, 9, 0x0120, 0x10, 14, 1),
	PIN_FIELD_BASE(64, 64, 9, 0x0120, 0x10, 0, 1),
	PIN_FIELD_BASE(65, 65, 9, 0x0120, 0x10, 11, 1),
	PIN_FIELD_BASE(66, 66, 9, 0x0120, 0x10, 16, 1),
	PIN_FIELD_BASE(67, 67, 9, 0x0120, 0x10, 18, 1),
	PIN_FIELD_BASE(68, 68, 9, 0x0120, 0x10, 18, 1),
	PIN_FIELD_BASE(69, 69, 9, 0x0120, 0x10, 18, 1),
	PIN_FIELD_BASE(70, 70, 9, 0x0120, 0x10, 17, 1),
	PIN_FIELD_BASE(71, 71, 9, 0x0120, 0x10, 17, 1),
	PIN_FIELD_BASE(72, 72, 9, 0x0120, 0x10, 18, 1),
	PIN_FIELD_BASE(73, 73, 9, 0x0120, 0x10, 17, 1),
	PIN_FIELD_BASE(74, 74, 9, 0x0120, 0x10, 17, 1),
	PIN_FIELD_BASE(75, 75, 10, 0x00b0, 0x10, 2, 1),
	PIN_FIELD_BASE(76, 76, 10, 0x00b0, 0x10, 3, 1),
	PIN_FIELD_BASE(77, 77, 10, 0x00b0, 0x10, 4, 1),
	PIN_FIELD_BASE(78, 78, 10, 0x00b0, 0x10, 5, 1),
	PIN_FIELD_BASE(79, 79, 10, 0x00b0, 0x10, 0, 1),
	PIN_FIELD_BASE(80, 80, 10, 0x00b0, 0x10, 1, 1),
	PIN_FIELD_BASE(81, 81, 11, 0x00a0, 0x10, 0, 1),
	PIN_FIELD_BASE(82, 82, 11, 0x00a0, 0x10, 0, 1),
	PIN_FIELD_BASE(83, 83, 11, 0x00a0, 0x10, 0, 1),
	PIN_FIELD_BASE(84, 84, 11, 0x00a0, 0x10, 0, 1),
	PIN_FIELD_BASE(85, 85, 11, 0x00a0, 0x10, 0, 1),
	PIN_FIELD_BASE(86, 86, 11, 0x00a0, 0x10, 0, 1),
	PIN_FIELD_BASE(87, 87, 11, 0x00a0, 0x10, 0, 1),
	PIN_FIELD_BASE(88, 88, 11, 0x00a0, 0x10, 0, 1),
	PIN_FIELD_BASE(89, 89, 11, 0x00a0, 0x10, 1, 1),
	PIN_FIELD_BASE(90, 90, 11, 0x00a0, 0x10, 1, 1),
	PIN_FIELD_BASE(91, 91, 12, 0x00c0, 0x10, 5, 1),
	PIN_FIELD_BASE(92, 92, 12, 0x00c0, 0x10, 5, 1),
	PIN_FIELD_BASE(93, 93, 12, 0x00c0, 0x10, 5, 1),
	PIN_FIELD_BASE(94, 94, 12, 0x00c0, 0x10, 4, 1),
	PIN_FIELD_BASE(95, 95, 12, 0x00c0, 0x10, 0, 1),
	PIN_FIELD_BASE(96, 96, 12, 0x00c0, 0x10, 2, 1),
	PIN_FIELD_BASE(97, 97, 12, 0x00c0, 0x10, 1, 1),
	PIN_FIELD_BASE(98, 98, 12, 0x00c0, 0x10, 3, 1),
	PIN_FIELD_BASE(99, 99, 12, 0x00c0, 0x10, 6, 1),
	PIN_FIELD_BASE(100, 100, 12, 0x00c0, 0x10, 9, 1),
	PIN_FIELD_BASE(101, 101, 12, 0x00c0, 0x10, 7, 1),
	PIN_FIELD_BASE(102, 102, 12, 0x00c0, 0x10, 10, 1),
	PIN_FIELD_BASE(103, 103, 12, 0x00c0, 0x10, 4, 1),
	PIN_FIELD_BASE(104, 104, 12, 0x00c0, 0x10, 8, 1),
	PIN_FIELD_BASE(105, 105, 12, 0x00c0, 0x10, 11, 1),
	PIN_FIELD_BASE(106, 106, 5, 0x00b0, 0x10, 0, 1),
	PIN_FIELD_BASE(107, 107, 5, 0x00b0, 0x10, 0, 1),
	PIN_FIELD_BASE(108, 108, 5, 0x00b0, 0x10, 0, 1),
	PIN_FIELD_BASE(109, 109, 5, 0x00b0, 0x10, 0, 1),
	PIN_FIELD_BASE(110, 110, 5, 0x00b0, 0x10, 1, 1),
	PIN_FIELD_BASE(111, 111, 5, 0x00b0, 0x10, 1, 1),
	PIN_FIELD_BASE(112, 112, 5, 0x00b0, 0x10, 1, 1),
	PIN_FIELD_BASE(113, 113, 5, 0x00b0, 0x10, 1, 1),
	PIN_FIELD_BASE(114, 114, 5, 0x00b0, 0x10, 0, 1),
	PIN_FIELD_BASE(115, 115, 5, 0x00b0, 0x10, 2, 1),
	PIN_FIELD_BASE(116, 116, 5, 0x00b0, 0x10, 2, 1),
	PIN_FIELD_BASE(117, 117, 5, 0x00b0, 0x10, 2, 1),
	PIN_FIELD_BASE(118, 118, 6, 0x0120, 0x10, 6, 1),
	PIN_FIELD_BASE(119, 119, 6, 0x0120, 0x10, 7, 1),
	PIN_FIELD_BASE(120, 120, 6, 0x0120, 0x10, 9, 1),
	PIN_FIELD_BASE(121, 121, 6, 0x0120, 0x10, 8, 1),
	PIN_FIELD_BASE(122, 122, 6, 0x0120, 0x10, 3, 1),
	PIN_FIELD_BASE(123, 123, 6, 0x0120, 0x10, 4, 1),
	PIN_FIELD_BASE(124, 124, 6, 0x0120, 0x10, 5, 1),
	PIN_FIELD_BASE(125, 125, 7, 0x00f0, 0x10, 0, 1),
	PIN_FIELD_BASE(126, 126, 7, 0x00f0, 0x10, 1, 1),
	PIN_FIELD_BASE(127, 127, 7, 0x00f0, 0x10, 2, 1),
	PIN_FIELD_BASE(128, 128, 7, 0x00f0, 0x10, 3, 1),
	PIN_FIELD_BASE(129, 129, 7, 0x00f0, 0x10, 4, 1),
	PIN_FIELD_BASE(130, 130, 7, 0x00f0, 0x10, 5, 1),
	PIN_FIELD_BASE(131, 131, 7, 0x00f0, 0x10, 9, 1),
	PIN_FIELD_BASE(132, 132, 7, 0x00f0, 0x10, 11, 1),
	PIN_FIELD_BASE(133, 133, 7, 0x00f0, 0x10, 10, 1),
	PIN_FIELD_BASE(134, 134, 7, 0x00f0, 0x10, 6, 1),
	PIN_FIELD_BASE(135, 135, 7, 0x00f0, 0x10, 8, 1),
	PIN_FIELD_BASE(136, 136, 7, 0x00f0, 0x10, 7, 1),
	PIN_FIELD_BASE(137, 137, 4, 0x00d0, 0x10, 2, 1),
	PIN_FIELD_BASE(138, 138, 4, 0x00d0, 0x10, 3, 1),
	PIN_FIELD_BASE(139, 139, 4, 0x00d0, 0x10, 4, 1),
	PIN_FIELD_BASE(140, 140, 4, 0x00d0, 0x10, 5, 1),
	PIN_FIELD_BASE(141, 141, 4, 0x00d0, 0x10, 6, 1),
	PIN_FIELD_BASE(142, 142, 4, 0x00d0, 0x10, 7, 1),
	PIN_FIELD_BASE(143, 143, 4, 0x00d0, 0x10, 8, 1),
	PIN_FIELD_BASE(144, 144, 4, 0x00d0, 0x10, 9, 1),
	PIN_FIELD_BASE(145, 145, 4, 0x00d0, 0x10, 10, 1),
	PIN_FIELD_BASE(146, 146, 4, 0x00d0, 0x10, 10, 1),
	PIN_FIELD_BASE(147, 147, 4, 0x00d0, 0x10, 0, 1),
	PIN_FIELD_BASE(148, 148, 4, 0x00d0, 0x10, 1, 1),
	PIN_FIELD_BASE(149, 149, 4, 0x00d0, 0x10, 11, 1),
	PIN_FIELD_BASE(150, 150, 4, 0x00d0, 0x10, 11, 1),
	PIN_FIELD_BASE(151, 151, 4, 0x00d0, 0x10, 11, 1),
	PIN_FIELD_BASE(152, 152, 4, 0x00d0, 0x10, 11, 1),
	PIN_FIELD_BASE(153, 153, 4, 0x00d0, 0x10, 13, 1),
	PIN_FIELD_BASE(154, 154, 4, 0x00d0, 0x10, 13, 1),
	PIN_FIELD_BASE(155, 155, 4, 0x00d0, 0x10, 12, 1),
	PIN_FIELD_BASE(156, 156, 4, 0x00d0, 0x10, 12, 1),
	PIN_FIELD_BASE(157, 157, 2, 0x00b0, 0x10, 6, 1),
	PIN_FIELD_BASE(158, 158, 2, 0x00b0, 0x10, 6, 1),
	PIN_FIELD_BASE(159, 159, 2, 0x00b0, 0x10, 6, 1),
	PIN_FIELD_BASE(160, 160, 3, 0x00c0, 0x10, 1, 1),
	PIN_FIELD_BASE(161, 161, 3, 0x00c0, 0x10, 2, 1),
	PIN_FIELD_BASE(162, 162, 3, 0x00c0, 0x10, 2, 1),
	PIN_FIELD_BASE(163, 163, 3, 0x00c0, 0x10, 2, 1),
	PIN_FIELD_BASE(164, 164, 3, 0x00c0, 0x10, 7, 1),
	PIN_FIELD_BASE(165, 165, 3, 0x00c0, 0x10, 9, 1),
	PIN_FIELD_BASE(166, 166, 3, 0x00c0, 0x10, 8, 1),
	PIN_FIELD_BASE(167, 167, 3, 0x00c0, 0x10, 10, 1),
	PIN_FIELD_BASE(168, 168, 3, 0x00c0, 0x10, 11, 1),
	PIN_FIELD_BASE(169, 169, 3, 0x00c0, 0x10, 3, 1),
	PIN_FIELD_BASE(170, 170, 3, 0x00c0, 0x10, 12, 1),
	PIN_FIELD_BASE(171, 171, 3, 0x00c0, 0x10, 3, 1),
	PIN_FIELD_BASE(172, 172, 3, 0x00c0, 0x10, 3, 1),
	PIN_FIELD_BASE(173, 173, 3, 0x00c0, 0x10, 3, 1),
	PIN_FIELD_BASE(174, 174, 1, 0x00c0, 0x10, 9, 1),
	PIN_FIELD_BASE(175, 175, 1, 0x00c0, 0x10, 9, 1),
	PIN_FIELD_BASE(176, 176, 1, 0x00c0, 0x10, 10, 1),
	PIN_FIELD_BASE(177, 177, 1, 0x00c0, 0x10, 11, 1),
	PIN_FIELD_BASE(178, 178, 1, 0x00c0, 0x10, 7, 1),
	PIN_FIELD_BASE(179, 179, 1, 0x00c0, 0x10, 7, 1),
	PIN_FIELD_BASE(180, 180, 1, 0x00c0, 0x10, 0, 1),
	PIN_FIELD_BASE(181, 181, 1, 0x00c0, 0x10, 1, 1),
	PIN_FIELD_BASE(182, 182, 1, 0x00c0, 0x10, 2, 1),
	PIN_FIELD_BASE(183, 183, 1, 0x00c0, 0x10, 3, 1),
	PIN_FIELD_BASE(184, 184, 1, 0x00c0, 0x10, 4, 1),
	PIN_FIELD_BASE(185, 185, 1, 0x00c0, 0x10, 5, 1),
	PIN_FIELD_BASE(186, 186, 13, 0x0110, 0x10, 14, 1),
	PIN_FIELD_BASE(187, 187, 13, 0x0110, 0x10, 14, 1),
	PIN_FIELD_BASE(188, 188, 13, 0x0110, 0x10, 4, 1),
	PIN_FIELD_BASE(189, 189, 13, 0x0110, 0x10, 9, 1),
	PIN_FIELD_BASE(190, 190, 13, 0x0110, 0x10, 5, 1),
	PIN_FIELD_BASE(191, 191, 13, 0x0110, 0x10, 10, 1),
	PIN_FIELD_BASE(192, 192, 13, 0x0110, 0x10, 0, 1),
	PIN_FIELD_BASE(193, 193, 13, 0x0110, 0x10, 15, 1),
	PIN_FIELD_BASE(194, 194, 13, 0x0110, 0x10, 6, 1),
	PIN_FIELD_BASE(195, 195, 13, 0x0110, 0x10, 11, 1),
	PIN_FIELD_BASE(196, 196, 13, 0x0110, 0x10, 1, 1),
	PIN_FIELD_BASE(197, 197, 13, 0x0110, 0x10, 16, 1),
	PIN_FIELD_BASE(198, 198, 13, 0x0110, 0x10, 7, 1),
	PIN_FIELD_BASE(199, 199, 13, 0x0110, 0x10, 12, 1),
	PIN_FIELD_BASE(200, 200, 13, 0x0110, 0x10, 19, 1),
	PIN_FIELD_BASE(201, 201, 13, 0x0110, 0x10, 22, 1),
	PIN_FIELD_BASE(202, 202, 13, 0x0110, 0x10, 8, 1),
	PIN_FIELD_BASE(203, 203, 13, 0x0110, 0x10, 13, 1),
	PIN_FIELD_BASE(204, 204, 13, 0x0110, 0x10, 2, 1),
	PIN_FIELD_BASE(205, 205, 13, 0x0110, 0x10, 3, 1),
	PIN_FIELD_BASE(206, 206, 13, 0x0110, 0x10, 18, 1),
	PIN_FIELD_BASE(207, 207, 13, 0x0110, 0x10, 17, 1),
	PIN_FIELD_BASE(208, 208, 13, 0x0110, 0x10, 17, 1),
	PIN_FIELD_BASE(209, 209, 13, 0x0110, 0x10, 17, 1),
	PIN_FIELD_BASE(210, 210, 14, 0x0130, 0x10, 0, 1),
	PIN_FIELD_BASE(211, 211, 14, 0x0130, 0x10, 1, 1),
	PIN_FIELD_BASE(212, 212, 14, 0x0130, 0x10, 2, 1),
	PIN_FIELD_BASE(213, 213, 14, 0x0130, 0x10, 3, 1),
	PIN_FIELD_BASE(214, 214, 13, 0x0110, 0x10, 20, 1),
	PIN_FIELD_BASE(215, 215, 13, 0x0110, 0x10, 21, 1),
	PIN_FIELD_BASE(216, 216, 14, 0x0130, 0x10, 11, 1),
	PIN_FIELD_BASE(217, 217, 14, 0x0130, 0x10, 11, 1),
	PIN_FIELD_BASE(218, 218, 14, 0x0130, 0x10, 11, 1),
	PIN_FIELD_BASE(219, 219, 14, 0x0130, 0x10, 4, 1),
	PIN_FIELD_BASE(220, 220, 14, 0x0130, 0x10, 11, 1),
	PIN_FIELD_BASE(221, 221, 14, 0x0130, 0x10, 12, 1),
	PIN_FIELD_BASE(222, 222, 14, 0x0130, 0x10, 22, 1),
	PIN_FIELD_BASE(223, 223, 14, 0x0130, 0x10, 21, 1),
	PIN_FIELD_BASE(224, 224, 14, 0x0130, 0x10, 5, 1),
	PIN_FIELD_BASE(225, 225, 14, 0x0130, 0x10, 6, 1),
	PIN_FIELD_BASE(226, 226, 14, 0x0130, 0x10, 7, 1),
	PIN_FIELD_BASE(227, 227, 14, 0x0130, 0x10, 8, 1),
	PIN_FIELD_BASE(228, 228, 14, 0x0130, 0x10, 9, 1),
	PIN_FIELD_BASE(229, 229, 14, 0x0130, 0x10, 10, 1),
	PIN_FIELD_BASE(230, 230, 15, 0x00e0, 0x10, 0, 1),
	PIN_FIELD_BASE(231, 231, 15, 0x00e0, 0x10, 0, 1),
	PIN_FIELD_BASE(232, 232, 15, 0x00e0, 0x10, 0, 1),
	PIN_FIELD_BASE(233, 233, 15, 0x00e0, 0x10, 1, 1),
	PIN_FIELD_BASE(234, 234, 15, 0x00e0, 0x10, 1, 1),
	PIN_FIELD_BASE(235, 235, 15, 0x00e0, 0x10, 1, 1),
	PIN_FIELD_BASE(236, 236, 15, 0x00e0, 0x10, 1, 1),
	PIN_FIELD_BASE(237, 237, 15, 0x00e0, 0x10, 2, 1),
	PIN_FIELD_BASE(238, 238, 15, 0x00e0, 0x10, 2, 1),
	PIN_FIELD_BASE(239, 239, 15, 0x00e0, 0x10, 2, 1),
	PIN_FIELD_BASE(240, 240, 15, 0x00e0, 0x10, 2, 1),
	PIN_FIELD_BASE(241, 241, 15, 0x00e0, 0x10, 3, 1),
	PIN_FIELD_BASE(242, 242, 15, 0x00e0, 0x10, 3, 1),
	PIN_FIELD_BASE(243, 243, 15, 0x00e0, 0x10, 3, 1),
	PIN_FIELD_BASE(244, 244, 15, 0x00e0, 0x10, 3, 1),
	PIN_FIELD_BASE(245, 245, 15, 0x00e0, 0x10, 4, 1),
	PIN_FIELD_BASE(246, 246, 15, 0x00e0, 0x10, 5, 1),
	PIN_FIELD_BASE(247, 247, 15, 0x00e0, 0x10, 5, 1),
	PIN_FIELD_BASE(248, 248, 15, 0x00e0, 0x10, 4, 1),
	PIN_FIELD_BASE(249, 249, 15, 0x00e0, 0x10, 4, 1),
	PIN_FIELD_BASE(250, 250, 15, 0x00e0, 0x10, 4, 1),
	PIN_FIELD_BASE(251, 251, 3, 0x00c0, 0x10, 4, 1),
	PIN_FIELD_BASE(252, 252, 3, 0x00c0, 0x10, 4, 1),
	PIN_FIELD_BASE(253, 253, 3, 0x00c0, 0x10, 4, 1),
	PIN_FIELD_BASE(254, 254, 3, 0x00c0, 0x10, 5, 1),
	PIN_FIELD_BASE(255, 255, 3, 0x00c0, 0x10, 5, 1),
	PIN_FIELD_BASE(256, 256, 3, 0x00c0, 0x10, 5, 1),
	PIN_FIELD_BASE(257, 257, 3, 0x00c0, 0x10, 5, 1),
	PIN_FIELD_BASE(258, 258, 3, 0x00c0, 0x10, 6, 1),
	PIN_FIELD_BASE(259, 259, 14, 0x0130, 0x10, 13, 1),
	PIN_FIELD_BASE(260, 260, 14, 0x0130, 0x10, 14, 1),
	PIN_FIELD_BASE(261, 261, 14, 0x0130, 0x10, 15, 1),
	PIN_FIELD_BASE(262, 262, 14, 0x0130, 0x10, 16, 1),
	PIN_FIELD_BASE(263, 263, 14, 0x0130, 0x10, 17, 1),
	PIN_FIELD_BASE(264, 264, 14, 0x0130, 0x10, 18, 1),
	PIN_FIELD_BASE(265, 265, 14, 0x0130, 0x10, 19, 1),
	PIN_FIELD_BASE(266, 266, 14, 0x0130, 0x10, 20, 1),
	PIN_FIELD_BASE(267, 267, 15, 0x00e0, 0x10, 8, 1),
	PIN_FIELD_BASE(268, 268, 15, 0x00e0, 0x10, 9, 1),
	PIN_FIELD_BASE(269, 269, 15, 0x00e0, 0x10, 6, 1),
	PIN_FIELD_BASE(270, 270, 15, 0x00e0, 0x10, 7, 1),
};

static const struct mtk_pin_field_calc mt8196_pin_ies_range[] = {
	PIN_FIELD_BASE(0, 0, 8, 0x0060, 0x10, 0, 1),
	PIN_FIELD_BASE(1, 1, 8, 0x0060, 0x10, 1, 1),
	PIN_FIELD_BASE(2, 2, 11, 0x0040, 0x10, 1, 1),
	PIN_FIELD_BASE(3, 3, 11, 0x0040, 0x10, 2, 1),
	PIN_FIELD_BASE(4, 4, 11, 0x0040, 0x10, 3, 1),
	PIN_FIELD_BASE(5, 5, 11, 0x0040, 0x10, 4, 1),
	PIN_FIELD_BASE(6, 6, 11, 0x0040, 0x10, 5, 1),
	PIN_FIELD_BASE(7, 7, 11, 0x0040, 0x10, 6, 1),
	PIN_FIELD_BASE(8, 8, 11, 0x0040, 0x10, 7, 1),
	PIN_FIELD_BASE(9, 9, 9, 0x0070, 0x10, 14, 1),
	PIN_FIELD_BASE(10, 10, 9, 0x0070, 0x10, 12, 1),
	PIN_FIELD_BASE(11, 11, 8, 0x0060, 0x10, 2, 1),
	PIN_FIELD_BASE(12, 12, 9, 0x0070, 0x10, 13, 1),
	PIN_FIELD_BASE(13, 13, 6, 0x0060, 0x10, 1, 1),
	PIN_FIELD_BASE(14, 14, 3, 0x0050, 0x10, 0, 1),
	PIN_FIELD_BASE(15, 15, 6, 0x0060, 0x10, 2, 1),
	PIN_FIELD_BASE(16, 16, 6, 0x0060, 0x10, 3, 1),
	PIN_FIELD_BASE(17, 17, 6, 0x0060, 0x10, 4, 1),
	PIN_FIELD_BASE(18, 18, 6, 0x0060, 0x10, 5, 1),
	PIN_FIELD_BASE(19, 19, 6, 0x0060, 0x10, 6, 1),
	PIN_FIELD_BASE(20, 20, 3, 0x0050, 0x10, 1, 1),
	PIN_FIELD_BASE(21, 21, 2, 0x0050, 0x10, 3, 1),
	PIN_FIELD_BASE(22, 22, 2, 0x0050, 0x10, 4, 1),
	PIN_FIELD_BASE(23, 23, 2, 0x0050, 0x10, 5, 1),
	PIN_FIELD_BASE(24, 24, 2, 0x0050, 0x10, 6, 1),
	PIN_FIELD_BASE(25, 25, 2, 0x0050, 0x10, 7, 1),
	PIN_FIELD_BASE(26, 26, 2, 0x0050, 0x10, 8, 1),
	PIN_FIELD_BASE(27, 27, 2, 0x0050, 0x10, 9, 1),
	PIN_FIELD_BASE(28, 28, 2, 0x0050, 0x10, 10, 1),
	PIN_FIELD_BASE(29, 29, 2, 0x0050, 0x10, 11, 1),
	PIN_FIELD_BASE(30, 30, 2, 0x0050, 0x10, 12, 1),
	PIN_FIELD_BASE(31, 31, 2, 0x0050, 0x10, 13, 1),
	PIN_FIELD_BASE(32, 32, 1, 0x0050, 0x10, 8, 1),
	PIN_FIELD_BASE(33, 33, 1, 0x0050, 0x10, 9, 1),
	PIN_FIELD_BASE(34, 34, 1, 0x0050, 0x10, 10, 1),
	PIN_FIELD_BASE(35, 35, 1, 0x0050, 0x10, 11, 1),
	PIN_FIELD_BASE(36, 36, 1, 0x0050, 0x10, 12, 1),
	PIN_FIELD_BASE(37, 37, 1, 0x0050, 0x10, 13, 1),
	PIN_FIELD_BASE(38, 38, 1, 0x0050, 0x10, 14, 1),
	PIN_FIELD_BASE(39, 39, 8, 0x0060, 0x10, 6, 1),
	PIN_FIELD_BASE(40, 40, 8, 0x0060, 0x10, 3, 1),
	PIN_FIELD_BASE(41, 41, 8, 0x0060, 0x10, 5, 1),
	PIN_FIELD_BASE(42, 42, 8, 0x0060, 0x10, 4, 1),
	PIN_FIELD_BASE(43, 43, 8, 0x0060, 0x10, 7, 1),
	PIN_FIELD_BASE(44, 44, 8, 0x0060, 0x10, 8, 1),
	PIN_FIELD_BASE(45, 45, 8, 0x0060, 0x10, 9, 1),
	PIN_FIELD_BASE(46, 46, 8, 0x0060, 0x10, 10, 1),
	PIN_FIELD_BASE(47, 47, 8, 0x0060, 0x10, 13, 1),
	PIN_FIELD_BASE(48, 48, 8, 0x0060, 0x10, 11, 1),
	PIN_FIELD_BASE(49, 49, 8, 0x0060, 0x10, 14, 1),
	PIN_FIELD_BASE(50, 50, 8, 0x0060, 0x10, 12, 1),
	PIN_FIELD_BASE(51, 51, 8, 0x0060, 0x10, 15, 1),
	PIN_FIELD_BASE(52, 52, 9, 0x0070, 0x10, 7, 1),
	PIN_FIELD_BASE(53, 53, 9, 0x0070, 0x10, 8, 1),
	PIN_FIELD_BASE(54, 54, 9, 0x0070, 0x10, 2, 1),
	PIN_FIELD_BASE(55, 55, 9, 0x0070, 0x10, 1, 1),
	PIN_FIELD_BASE(56, 56, 9, 0x0070, 0x10, 5, 1),
	PIN_FIELD_BASE(57, 57, 9, 0x0070, 0x10, 6, 1),
	PIN_FIELD_BASE(58, 58, 9, 0x0070, 0x10, 3, 1),
	PIN_FIELD_BASE(59, 59, 9, 0x0070, 0x10, 4, 1),
	PIN_FIELD_BASE(60, 60, 9, 0x0070, 0x10, 19, 1),
	PIN_FIELD_BASE(61, 61, 9, 0x0070, 0x10, 10, 1),
	PIN_FIELD_BASE(62, 62, 9, 0x0070, 0x10, 9, 1),
	PIN_FIELD_BASE(63, 63, 9, 0x0070, 0x10, 18, 1),
	PIN_FIELD_BASE(64, 64, 9, 0x0070, 0x10, 0, 1),
	PIN_FIELD_BASE(65, 65, 9, 0x0070, 0x10, 11, 1),
	PIN_FIELD_BASE(66, 66, 9, 0x0070, 0x10, 24, 1),
	PIN_FIELD_BASE(67, 67, 9, 0x0070, 0x10, 22, 1),
	PIN_FIELD_BASE(68, 68, 9, 0x0070, 0x10, 21, 1),
	PIN_FIELD_BASE(69, 69, 9, 0x0070, 0x10, 25, 1),
	PIN_FIELD_BASE(70, 70, 9, 0x0070, 0x10, 16, 1),
	PIN_FIELD_BASE(71, 71, 9, 0x0070, 0x10, 15, 1),
	PIN_FIELD_BASE(72, 72, 9, 0x0070, 0x10, 23, 1),
	PIN_FIELD_BASE(73, 73, 9, 0x0070, 0x10, 20, 1),
	PIN_FIELD_BASE(74, 74, 9, 0x0070, 0x10, 17, 1),
	PIN_FIELD_BASE(75, 75, 10, 0x0050, 0x10, 2, 1),
	PIN_FIELD_BASE(76, 76, 10, 0x0050, 0x10, 3, 1),
	PIN_FIELD_BASE(77, 77, 10, 0x0050, 0x10, 4, 1),
	PIN_FIELD_BASE(78, 78, 10, 0x0050, 0x10, 5, 1),
	PIN_FIELD_BASE(79, 79, 10, 0x0050, 0x10, 0, 1),
	PIN_FIELD_BASE(80, 80, 10, 0x0050, 0x10, 1, 1),
	PIN_FIELD_BASE(81, 81, 11, 0x0040, 0x10, 9, 1),
	PIN_FIELD_BASE(82, 82, 11, 0x0040, 0x10, 10, 1),
	PIN_FIELD_BASE(83, 83, 11, 0x0040, 0x10, 12, 1),
	PIN_FIELD_BASE(84, 84, 11, 0x0040, 0x10, 11, 1),
	PIN_FIELD_BASE(85, 85, 11, 0x0040, 0x10, 13, 1),
	PIN_FIELD_BASE(86, 86, 11, 0x0040, 0x10, 14, 1),
	PIN_FIELD_BASE(87, 87, 11, 0x0040, 0x10, 16, 1),
	PIN_FIELD_BASE(88, 88, 11, 0x0040, 0x10, 15, 1),
	PIN_FIELD_BASE(89, 89, 11, 0x0040, 0x10, 0, 1),
	PIN_FIELD_BASE(90, 90, 11, 0x0040, 0x10, 8, 1),
	PIN_FIELD_BASE(91, 91, 12, 0x0050, 0x10, 6, 1),
	PIN_FIELD_BASE(92, 92, 12, 0x0050, 0x10, 7, 1),
	PIN_FIELD_BASE(93, 93, 12, 0x0050, 0x10, 8, 1),
	PIN_FIELD_BASE(94, 94, 12, 0x0050, 0x10, 4, 1),
	PIN_FIELD_BASE(95, 95, 12, 0x0050, 0x10, 1, 1),
	PIN_FIELD_BASE(96, 96, 12, 0x0050, 0x10, 3, 1),
	PIN_FIELD_BASE(97, 97, 12, 0x0050, 0x10, 2, 1),
	PIN_FIELD_BASE(98, 98, 12, 0x0050, 0x10, 5, 1),
	PIN_FIELD_BASE(99, 99, 12, 0x0050, 0x10, 9, 1),
	PIN_FIELD_BASE(100, 100, 12, 0x0050, 0x10, 12, 1),
	PIN_FIELD_BASE(101, 101, 12, 0x0050, 0x10, 10, 1),
	PIN_FIELD_BASE(102, 102, 12, 0x0050, 0x10, 13, 1),
	PIN_FIELD_BASE(103, 103, 12, 0x0050, 0x10, 0, 1),
	PIN_FIELD_BASE(104, 104, 12, 0x0050, 0x10, 11, 1),
	PIN_FIELD_BASE(105, 105, 12, 0x0050, 0x10, 14, 1),
	PIN_FIELD_BASE(106, 106, 5, 0x0050, 0x10, 0, 1),
	PIN_FIELD_BASE(107, 107, 5, 0x0050, 0x10, 1, 1),
	PIN_FIELD_BASE(108, 108, 5, 0x0050, 0x10, 3, 1),
	PIN_FIELD_BASE(109, 109, 5, 0x0050, 0x10, 2, 1),
	PIN_FIELD_BASE(110, 110, 5, 0x0050, 0x10, 4, 1),
	PIN_FIELD_BASE(111, 111, 5, 0x0050, 0x10, 5, 1),
	PIN_FIELD_BASE(112, 112, 5, 0x0050, 0x10, 7, 1),
	PIN_FIELD_BASE(113, 113, 5, 0x0050, 0x10, 6, 1),
	PIN_FIELD_BASE(114, 114, 5, 0x0050, 0x10, 8, 1),
	PIN_FIELD_BASE(115, 115, 5, 0x0050, 0x10, 9, 1),
	PIN_FIELD_BASE(116, 116, 5, 0x0050, 0x10, 11, 1),
	PIN_FIELD_BASE(117, 117, 5, 0x0050, 0x10, 10, 1),
	PIN_FIELD_BASE(118, 118, 6, 0x0060, 0x10, 9, 1),
	PIN_FIELD_BASE(119, 119, 6, 0x0060, 0x10, 10, 1),
	PIN_FIELD_BASE(120, 120, 6, 0x0060, 0x10, 12, 1),
	PIN_FIELD_BASE(121, 121, 6, 0x0060, 0x10, 11, 1),
	PIN_FIELD_BASE(122, 122, 6, 0x0060, 0x10, 0, 1),
	PIN_FIELD_BASE(123, 123, 6, 0x0060, 0x10, 7, 1),
	PIN_FIELD_BASE(124, 124, 6, 0x0060, 0x10, 8, 1),
	PIN_FIELD_BASE(125, 125, 7, 0x0050, 0x10, 0, 1),
	PIN_FIELD_BASE(126, 126, 7, 0x0050, 0x10, 1, 1),
	PIN_FIELD_BASE(127, 127, 7, 0x0050, 0x10, 2, 1),
	PIN_FIELD_BASE(128, 128, 7, 0x0050, 0x10, 3, 1),
	PIN_FIELD_BASE(129, 129, 7, 0x0050, 0x10, 4, 1),
	PIN_FIELD_BASE(130, 130, 7, 0x0050, 0x10, 5, 1),
	PIN_FIELD_BASE(131, 131, 7, 0x0050, 0x10, 9, 1),
	PIN_FIELD_BASE(132, 132, 7, 0x0050, 0x10, 11, 1),
	PIN_FIELD_BASE(133, 133, 7, 0x0050, 0x10, 10, 1),
	PIN_FIELD_BASE(134, 134, 7, 0x0050, 0x10, 6, 1),
	PIN_FIELD_BASE(135, 135, 7, 0x0050, 0x10, 8, 1),
	PIN_FIELD_BASE(136, 136, 7, 0x0050, 0x10, 7, 1),
	PIN_FIELD_BASE(137, 137, 4, 0x0040, 0x10, 10, 1),
	PIN_FIELD_BASE(138, 138, 4, 0x0040, 0x10, 11, 1),
	PIN_FIELD_BASE(139, 139, 4, 0x0040, 0x10, 12, 1),
	PIN_FIELD_BASE(140, 140, 4, 0x0040, 0x10, 13, 1),
	PIN_FIELD_BASE(141, 141, 4, 0x0040, 0x10, 14, 1),
	PIN_FIELD_BASE(142, 142, 4, 0x0040, 0x10, 15, 1),
	PIN_FIELD_BASE(143, 143, 4, 0x0040, 0x10, 16, 1),
	PIN_FIELD_BASE(144, 144, 4, 0x0040, 0x10, 17, 1),
	PIN_FIELD_BASE(145, 145, 4, 0x0040, 0x10, 0, 1),
	PIN_FIELD_BASE(146, 146, 4, 0x0040, 0x10, 1, 1),
	PIN_FIELD_BASE(147, 147, 4, 0x0040, 0x10, 2, 1),
	PIN_FIELD_BASE(148, 148, 4, 0x0040, 0x10, 3, 1),
	PIN_FIELD_BASE(149, 149, 4, 0x0040, 0x10, 4, 1),
	PIN_FIELD_BASE(150, 150, 4, 0x0040, 0x10, 5, 1),
	PIN_FIELD_BASE(151, 151, 4, 0x0040, 0x10, 6, 1),
	PIN_FIELD_BASE(152, 152, 4, 0x0040, 0x10, 7, 1),
	PIN_FIELD_BASE(153, 153, 4, 0x0040, 0x10, 9, 1),
	PIN_FIELD_BASE(154, 154, 4, 0x0040, 0x10, 8, 1),
	PIN_FIELD_BASE(155, 155, 4, 0x0040, 0x10, 18, 1),
	PIN_FIELD_BASE(156, 156, 4, 0x0040, 0x10, 19, 1),
	PIN_FIELD_BASE(157, 157, 2, 0x0050, 0x10, 1, 1),
	PIN_FIELD_BASE(158, 158, 2, 0x0050, 0x10, 2, 1),
	PIN_FIELD_BASE(159, 159, 2, 0x0050, 0x10, 0, 1),
	PIN_FIELD_BASE(160, 160, 3, 0x0050, 0x10, 22, 1),
	PIN_FIELD_BASE(161, 161, 3, 0x0050, 0x10, 20, 1),
	PIN_FIELD_BASE(162, 162, 3, 0x0050, 0x10, 23, 1),
	PIN_FIELD_BASE(163, 163, 3, 0x0050, 0x10, 21, 1),
	PIN_FIELD_BASE(164, 164, 3, 0x0050, 0x10, 12, 1),
	PIN_FIELD_BASE(165, 165, 3, 0x0050, 0x10, 14, 1),
	PIN_FIELD_BASE(166, 166, 3, 0x0050, 0x10, 13, 1),
	PIN_FIELD_BASE(167, 167, 3, 0x0050, 0x10, 15, 1),
	PIN_FIELD_BASE(168, 168, 3, 0x0050, 0x10, 16, 1),
	PIN_FIELD_BASE(169, 169, 3, 0x0050, 0x10, 17, 1),
	PIN_FIELD_BASE(170, 170, 3, 0x0050, 0x10, 19, 1),
	PIN_FIELD_BASE(171, 171, 3, 0x0050, 0x10, 18, 1),
	PIN_FIELD_BASE(172, 172, 3, 0x0050, 0x10, 10, 1),
	PIN_FIELD_BASE(173, 173, 3, 0x0050, 0x10, 11, 1),
	PIN_FIELD_BASE(174, 174, 1, 0x0050, 0x10, 15, 1),
	PIN_FIELD_BASE(175, 175, 1, 0x0050, 0x10, 16, 1),
	PIN_FIELD_BASE(176, 176, 1, 0x0050, 0x10, 17, 1),
	PIN_FIELD_BASE(177, 177, 1, 0x0050, 0x10, 18, 1),
	PIN_FIELD_BASE(178, 178, 1, 0x0050, 0x10, 6, 1),
	PIN_FIELD_BASE(179, 179, 1, 0x0050, 0x10, 7, 1),
	PIN_FIELD_BASE(180, 180, 1, 0x0050, 0x10, 0, 1),
	PIN_FIELD_BASE(181, 181, 1, 0x0050, 0x10, 1, 1),
	PIN_FIELD_BASE(182, 182, 1, 0x0050, 0x10, 2, 1),
	PIN_FIELD_BASE(183, 183, 1, 0x0050, 0x10, 3, 1),
	PIN_FIELD_BASE(184, 184, 1, 0x0050, 0x10, 4, 1),
	PIN_FIELD_BASE(185, 185, 1, 0x0050, 0x10, 5, 1),
	PIN_FIELD_BASE(186, 186, 13, 0x0090, 0x10, 4, 1),
	PIN_FIELD_BASE(187, 187, 13, 0x0090, 0x10, 5, 1),
	PIN_FIELD_BASE(188, 188, 13, 0x0090, 0x10, 12, 1),
	PIN_FIELD_BASE(189, 189, 13, 0x0090, 0x10, 17, 1),
	PIN_FIELD_BASE(190, 190, 13, 0x0090, 0x10, 13, 1),
	PIN_FIELD_BASE(191, 191, 13, 0x0090, 0x10, 18, 1),
	PIN_FIELD_BASE(192, 192, 13, 0x0090, 0x10, 0, 1),
	PIN_FIELD_BASE(193, 193, 13, 0x0090, 0x10, 6, 1),
	PIN_FIELD_BASE(194, 194, 13, 0x0090, 0x10, 14, 1),
	PIN_FIELD_BASE(195, 195, 13, 0x0090, 0x10, 19, 1),
	PIN_FIELD_BASE(196, 196, 13, 0x0090, 0x10, 1, 1),
	PIN_FIELD_BASE(197, 197, 13, 0x0090, 0x10, 7, 1),
	PIN_FIELD_BASE(198, 198, 13, 0x0090, 0x10, 15, 1),
	PIN_FIELD_BASE(199, 199, 13, 0x0090, 0x10, 20, 1),
	PIN_FIELD_BASE(200, 200, 13, 0x0090, 0x10, 22, 1),
	PIN_FIELD_BASE(201, 201, 13, 0x0090, 0x10, 25, 1),
	PIN_FIELD_BASE(202, 202, 13, 0x0090, 0x10, 16, 1),
	PIN_FIELD_BASE(203, 203, 13, 0x0090, 0x10, 21, 1),
	PIN_FIELD_BASE(204, 204, 13, 0x0090, 0x10, 2, 1),
	PIN_FIELD_BASE(205, 205, 13, 0x0090, 0x10, 3, 1),
	PIN_FIELD_BASE(206, 206, 13, 0x0090, 0x10, 8, 1),
	PIN_FIELD_BASE(207, 207, 13, 0x0090, 0x10, 9, 1),
	PIN_FIELD_BASE(208, 208, 13, 0x0090, 0x10, 10, 1),
	PIN_FIELD_BASE(209, 209, 13, 0x0090, 0x10, 11, 1),
	PIN_FIELD_BASE(210, 210, 14, 0x0060, 0x10, 0, 1),
	PIN_FIELD_BASE(211, 211, 14, 0x0060, 0x10, 1, 1),
	PIN_FIELD_BASE(212, 212, 14, 0x0060, 0x10, 2, 1),
	PIN_FIELD_BASE(213, 213, 14, 0x0060, 0x10, 3, 1),
	PIN_FIELD_BASE(214, 214, 13, 0x0090, 0x10, 23, 1),
	PIN_FIELD_BASE(215, 215, 13, 0x0090, 0x10, 24, 1),
	PIN_FIELD_BASE(216, 216, 14, 0x0060, 0x10, 13, 1),
	PIN_FIELD_BASE(217, 217, 14, 0x0060, 0x10, 5, 1),
	PIN_FIELD_BASE(218, 218, 14, 0x0060, 0x10, 6, 1),
	PIN_FIELD_BASE(219, 219, 14, 0x0060, 0x10, 4, 1),
	PIN_FIELD_BASE(220, 220, 14, 0x0060, 0x10, 22, 1),
	PIN_FIELD_BASE(221, 221, 14, 0x0060, 0x10, 23, 1),
	PIN_FIELD_BASE(222, 222, 14, 0x0060, 0x10, 25, 1),
	PIN_FIELD_BASE(223, 223, 14, 0x0060, 0x10, 24, 1),
	PIN_FIELD_BASE(224, 224, 14, 0x0060, 0x10, 7, 1),
	PIN_FIELD_BASE(225, 225, 14, 0x0060, 0x10, 8, 1),
	PIN_FIELD_BASE(226, 226, 14, 0x0060, 0x10, 9, 1),
	PIN_FIELD_BASE(227, 227, 14, 0x0060, 0x10, 10, 1),
	PIN_FIELD_BASE(228, 228, 14, 0x0060, 0x10, 11, 1),
	PIN_FIELD_BASE(229, 229, 14, 0x0060, 0x10, 12, 1),
	PIN_FIELD_BASE(230, 230, 15, 0x0040, 0x10, 13, 1),
	PIN_FIELD_BASE(231, 231, 15, 0x0040, 0x10, 14, 1),
	PIN_FIELD_BASE(232, 232, 15, 0x0040, 0x10, 10, 1),
	PIN_FIELD_BASE(233, 233, 15, 0x0040, 0x10, 0, 1),
	PIN_FIELD_BASE(234, 234, 15, 0x0040, 0x10, 3, 1),
	PIN_FIELD_BASE(235, 235, 15, 0x0040, 0x10, 1, 1),
	PIN_FIELD_BASE(236, 236, 15, 0x0040, 0x10, 2, 1),
	PIN_FIELD_BASE(237, 237, 15, 0x0040, 0x10, 6, 1),
	PIN_FIELD_BASE(238, 238, 15, 0x0040, 0x10, 5, 1),
	PIN_FIELD_BASE(239, 239, 15, 0x0040, 0x10, 23, 1),
	PIN_FIELD_BASE(240, 240, 15, 0x0040, 0x10, 22, 1),
	PIN_FIELD_BASE(241, 241, 15, 0x0040, 0x10, 16, 1),
	PIN_FIELD_BASE(242, 242, 15, 0x0040, 0x10, 17, 1),
	PIN_FIELD_BASE(243, 243, 15, 0x0040, 0x10, 15, 1),
	PIN_FIELD_BASE(244, 244, 15, 0x0040, 0x10, 12, 1),
	PIN_FIELD_BASE(245, 245, 15, 0x0040, 0x10, 9, 1),
	PIN_FIELD_BASE(246, 246, 15, 0x0040, 0x10, 8, 1),
	PIN_FIELD_BASE(247, 247, 15, 0x0040, 0x10, 7, 1),
	PIN_FIELD_BASE(248, 248, 15, 0x0040, 0x10, 4, 1),
	PIN_FIELD_BASE(249, 249, 15, 0x0040, 0x10, 24, 1),
	PIN_FIELD_BASE(250, 250, 15, 0x0040, 0x10, 11, 1),
	PIN_FIELD_BASE(251, 251, 3, 0x0050, 0x10, 2, 1),
	PIN_FIELD_BASE(252, 252, 3, 0x0050, 0x10, 3, 1),
	PIN_FIELD_BASE(253, 253, 3, 0x0050, 0x10, 4, 1),
	PIN_FIELD_BASE(254, 254, 3, 0x0050, 0x10, 5, 1),
	PIN_FIELD_BASE(255, 255, 3, 0x0050, 0x10, 6, 1),
	PIN_FIELD_BASE(256, 256, 3, 0x0050, 0x10, 7, 1),
	PIN_FIELD_BASE(257, 257, 3, 0x0050, 0x10, 8, 1),
	PIN_FIELD_BASE(258, 258, 3, 0x0050, 0x10, 9, 1),
	PIN_FIELD_BASE(259, 259, 14, 0x0060, 0x10, 14, 1),
	PIN_FIELD_BASE(260, 260, 14, 0x0060, 0x10, 15, 1),
	PIN_FIELD_BASE(261, 261, 14, 0x0060, 0x10, 16, 1),
	PIN_FIELD_BASE(262, 262, 14, 0x0060, 0x10, 17, 1),
	PIN_FIELD_BASE(263, 263, 14, 0x0060, 0x10, 18, 1),
	PIN_FIELD_BASE(264, 264, 14, 0x0060, 0x10, 19, 1),
	PIN_FIELD_BASE(265, 265, 14, 0x0060, 0x10, 20, 1),
	PIN_FIELD_BASE(266, 266, 14, 0x0060, 0x10, 21, 1),
	PIN_FIELD_BASE(267, 267, 15, 0x0040, 0x10, 20, 1),
	PIN_FIELD_BASE(268, 268, 15, 0x0040, 0x10, 21, 1),
	PIN_FIELD_BASE(269, 269, 15, 0x0040, 0x10, 18, 1),
	PIN_FIELD_BASE(270, 270, 15, 0x0040, 0x10, 19, 1),
};

static const struct mtk_pin_field_calc mt8196_pin_pupd_range[] = {
	PIN_FIELD_BASE(60, 60, 9, 0x00b0, 0x10, 0, 1),
	PIN_FIELD_BASE(125, 125, 7, 0x0080, 0x10, 0, 1),
	PIN_FIELD_BASE(126, 126, 7, 0x0080, 0x10, 1, 1),
	PIN_FIELD_BASE(127, 127, 7, 0x0080, 0x10, 2, 1),
	PIN_FIELD_BASE(128, 128, 7, 0x0080, 0x10, 3, 1),
	PIN_FIELD_BASE(129, 129, 7, 0x0080, 0x10, 4, 1),
	PIN_FIELD_BASE(130, 130, 7, 0x0080, 0x10, 5, 1),
	PIN_FIELD_BASE(131, 131, 7, 0x0080, 0x10, 9, 1),
	PIN_FIELD_BASE(132, 132, 7, 0x0080, 0x10, 11, 1),
	PIN_FIELD_BASE(133, 133, 7, 0x0080, 0x10, 10, 1),
	PIN_FIELD_BASE(134, 134, 7, 0x0080, 0x10, 6, 1),
	PIN_FIELD_BASE(135, 135, 7, 0x0080, 0x10, 8, 1),
	PIN_FIELD_BASE(136, 136, 7, 0x0080, 0x10, 7, 1),
	PIN_FIELD_BASE(137, 137, 4, 0x0070, 0x10, 10, 1),
	PIN_FIELD_BASE(138, 138, 4, 0x0070, 0x10, 11, 1),
	PIN_FIELD_BASE(139, 139, 4, 0x0070, 0x10, 12, 1),
	PIN_FIELD_BASE(140, 140, 4, 0x0070, 0x10, 13, 1),
	PIN_FIELD_BASE(141, 141, 4, 0x0070, 0x10, 14, 1),
	PIN_FIELD_BASE(142, 142, 4, 0x0070, 0x10, 15, 1),
	PIN_FIELD_BASE(143, 143, 4, 0x0070, 0x10, 16, 1),
	PIN_FIELD_BASE(144, 144, 4, 0x0070, 0x10, 17, 1),
	PIN_FIELD_BASE(145, 145, 4, 0x0070, 0x10, 0, 1),
	PIN_FIELD_BASE(146, 146, 4, 0x0070, 0x10, 1, 1),
	PIN_FIELD_BASE(147, 147, 4, 0x0070, 0x10, 2, 1),
	PIN_FIELD_BASE(148, 148, 4, 0x0070, 0x10, 3, 1),
	PIN_FIELD_BASE(149, 149, 4, 0x0070, 0x10, 4, 1),
	PIN_FIELD_BASE(150, 150, 4, 0x0070, 0x10, 5, 1),
	PIN_FIELD_BASE(151, 151, 4, 0x0070, 0x10, 6, 1),
	PIN_FIELD_BASE(152, 152, 4, 0x0070, 0x10, 7, 1),
	PIN_FIELD_BASE(153, 153, 4, 0x0070, 0x10, 9, 1),
	PIN_FIELD_BASE(154, 154, 4, 0x0070, 0x10, 8, 1),
	PIN_FIELD_BASE(155, 155, 4, 0x0070, 0x10, 18, 1),
	PIN_FIELD_BASE(156, 156, 4, 0x0070, 0x10, 19, 1),
	PIN_FIELD_BASE(217, 217, 14, 0x00a0, 0x10, 1, 1),
	PIN_FIELD_BASE(218, 218, 14, 0x00a0, 0x10, 2, 1),
	PIN_FIELD_BASE(219, 219, 14, 0x00a0, 0x10, 0, 1),
	PIN_FIELD_BASE(224, 224, 14, 0x00a0, 0x10, 3, 1),
	PIN_FIELD_BASE(225, 225, 14, 0x00a0, 0x10, 4, 1),
	PIN_FIELD_BASE(226, 226, 14, 0x00a0, 0x10, 5, 1),
	PIN_FIELD_BASE(227, 227, 14, 0x00a0, 0x10, 6, 1),
	PIN_FIELD_BASE(228, 228, 14, 0x00a0, 0x10, 7, 1),
	PIN_FIELD_BASE(229, 229, 14, 0x00a0, 0x10, 8, 1),
	PIN_FIELD_BASE(259, 259, 14, 0x00a0, 0x10, 9, 1),
	PIN_FIELD_BASE(260, 260, 14, 0x00a0, 0x10, 10, 1),
	PIN_FIELD_BASE(261, 261, 14, 0x00a0, 0x10, 11, 1),
	PIN_FIELD_BASE(262, 262, 14, 0x00a0, 0x10, 12, 1),
	PIN_FIELD_BASE(263, 263, 14, 0x00a0, 0x10, 13, 1),
	PIN_FIELD_BASE(264, 264, 14, 0x00a0, 0x10, 14, 1),
	PIN_FIELD_BASE(265, 265, 14, 0x00a0, 0x10, 15, 1),
	PIN_FIELD_BASE(266, 266, 14, 0x00a0, 0x10, 16, 1),
	PIN_FIELD_BASE(267, 267, 15, 0x0080, 0x10, 2, 1),
	PIN_FIELD_BASE(268, 268, 15, 0x0080, 0x10, 3, 1),
	PIN_FIELD_BASE(269, 269, 15, 0x0080, 0x10, 0, 1),
	PIN_FIELD_BASE(270, 270, 15, 0x0080, 0x10, 1, 1),
};

static const struct mtk_pin_field_calc mt8196_pin_r0_range[] = {
	PIN_FIELD_BASE(60, 60, 9, 0x00d0, 0x10, 0, 1),
	PIN_FIELD_BASE(125, 125, 7, 0x0090, 0x10, 0, 1),
	PIN_FIELD_BASE(126, 126, 7, 0x0090, 0x10, 1, 1),
	PIN_FIELD_BASE(127, 127, 7, 0x0090, 0x10, 2, 1),
	PIN_FIELD_BASE(128, 128, 7, 0x0090, 0x10, 3, 1),
	PIN_FIELD_BASE(129, 129, 7, 0x0090, 0x10, 4, 1),
	PIN_FIELD_BASE(130, 130, 7, 0x0090, 0x10, 5, 1),
	PIN_FIELD_BASE(131, 131, 7, 0x0090, 0x10, 9, 1),
	PIN_FIELD_BASE(132, 132, 7, 0x0090, 0x10, 11, 1),
	PIN_FIELD_BASE(133, 133, 7, 0x0090, 0x10, 10, 1),
	PIN_FIELD_BASE(134, 134, 7, 0x0090, 0x10, 6, 1),
	PIN_FIELD_BASE(135, 135, 7, 0x0090, 0x10, 8, 1),
	PIN_FIELD_BASE(136, 136, 7, 0x0090, 0x10, 7, 1),
	PIN_FIELD_BASE(137, 137, 4, 0x0080, 0x10, 10, 1),
	PIN_FIELD_BASE(138, 138, 4, 0x0080, 0x10, 11, 1),
	PIN_FIELD_BASE(139, 139, 4, 0x0080, 0x10, 12, 1),
	PIN_FIELD_BASE(140, 140, 4, 0x0080, 0x10, 13, 1),
	PIN_FIELD_BASE(141, 141, 4, 0x0080, 0x10, 14, 1),
	PIN_FIELD_BASE(142, 142, 4, 0x0080, 0x10, 15, 1),
	PIN_FIELD_BASE(143, 143, 4, 0x0080, 0x10, 16, 1),
	PIN_FIELD_BASE(144, 144, 4, 0x0080, 0x10, 17, 1),
	PIN_FIELD_BASE(145, 145, 4, 0x0080, 0x10, 0, 1),
	PIN_FIELD_BASE(146, 146, 4, 0x0080, 0x10, 1, 1),
	PIN_FIELD_BASE(147, 147, 4, 0x0080, 0x10, 2, 1),
	PIN_FIELD_BASE(148, 148, 4, 0x0080, 0x10, 3, 1),
	PIN_FIELD_BASE(149, 149, 4, 0x0080, 0x10, 4, 1),
	PIN_FIELD_BASE(150, 150, 4, 0x0080, 0x10, 5, 1),
	PIN_FIELD_BASE(151, 151, 4, 0x0080, 0x10, 6, 1),
	PIN_FIELD_BASE(152, 152, 4, 0x0080, 0x10, 7, 1),
	PIN_FIELD_BASE(153, 153, 4, 0x0080, 0x10, 9, 1),
	PIN_FIELD_BASE(154, 154, 4, 0x0080, 0x10, 8, 1),
	PIN_FIELD_BASE(155, 155, 4, 0x0080, 0x10, 18, 1),
	PIN_FIELD_BASE(156, 156, 4, 0x0080, 0x10, 19, 1),
	PIN_FIELD_BASE(217, 217, 14, 0x00c0, 0x10, 1, 1),
	PIN_FIELD_BASE(218, 218, 14, 0x00c0, 0x10, 2, 1),
	PIN_FIELD_BASE(219, 219, 14, 0x00c0, 0x10, 0, 1),
	PIN_FIELD_BASE(224, 224, 14, 0x00c0, 0x10, 3, 1),
	PIN_FIELD_BASE(225, 225, 14, 0x00c0, 0x10, 4, 1),
	PIN_FIELD_BASE(226, 226, 14, 0x00c0, 0x10, 5, 1),
	PIN_FIELD_BASE(227, 227, 14, 0x00c0, 0x10, 6, 1),
	PIN_FIELD_BASE(228, 228, 14, 0x00c0, 0x10, 7, 1),
	PIN_FIELD_BASE(229, 229, 14, 0x00c0, 0x10, 8, 1),
	PIN_FIELD_BASE(259, 259, 14, 0x00c0, 0x10, 9, 1),
	PIN_FIELD_BASE(260, 260, 14, 0x00c0, 0x10, 10, 1),
	PIN_FIELD_BASE(261, 261, 14, 0x00c0, 0x10, 11, 1),
	PIN_FIELD_BASE(262, 262, 14, 0x00c0, 0x10, 12, 1),
	PIN_FIELD_BASE(263, 263, 14, 0x00c0, 0x10, 13, 1),
	PIN_FIELD_BASE(264, 264, 14, 0x00c0, 0x10, 14, 1),
	PIN_FIELD_BASE(265, 265, 14, 0x00c0, 0x10, 15, 1),
	PIN_FIELD_BASE(266, 266, 14, 0x00c0, 0x10, 16, 1),
	PIN_FIELD_BASE(267, 267, 15, 0x00a0, 0x10, 2, 1),
	PIN_FIELD_BASE(268, 268, 15, 0x00a0, 0x10, 3, 1),
	PIN_FIELD_BASE(269, 269, 15, 0x00a0, 0x10, 0, 1),
	PIN_FIELD_BASE(270, 270, 15, 0x00a0, 0x10, 1, 1),
};

static const struct mtk_pin_field_calc mt8196_pin_r1_range[] = {
	PIN_FIELD_BASE(60, 60, 9, 0x00e0, 0x10, 0, 1),
	PIN_FIELD_BASE(125, 125, 7, 0x00a0, 0x10, 0, 1),
	PIN_FIELD_BASE(126, 126, 7, 0x00a0, 0x10, 1, 1),
	PIN_FIELD_BASE(127, 127, 7, 0x00a0, 0x10, 2, 1),
	PIN_FIELD_BASE(128, 128, 7, 0x00a0, 0x10, 3, 1),
	PIN_FIELD_BASE(129, 129, 7, 0x00a0, 0x10, 4, 1),
	PIN_FIELD_BASE(130, 130, 7, 0x00a0, 0x10, 5, 1),
	PIN_FIELD_BASE(131, 131, 7, 0x00a0, 0x10, 9, 1),
	PIN_FIELD_BASE(132, 132, 7, 0x00a0, 0x10, 11, 1),
	PIN_FIELD_BASE(133, 133, 7, 0x00a0, 0x10, 10, 1),
	PIN_FIELD_BASE(134, 134, 7, 0x00a0, 0x10, 6, 1),
	PIN_FIELD_BASE(135, 135, 7, 0x00a0, 0x10, 8, 1),
	PIN_FIELD_BASE(136, 136, 7, 0x00a0, 0x10, 7, 1),
	PIN_FIELD_BASE(137, 137, 4, 0x0090, 0x10, 10, 1),
	PIN_FIELD_BASE(138, 138, 4, 0x0090, 0x10, 11, 1),
	PIN_FIELD_BASE(139, 139, 4, 0x0090, 0x10, 12, 1),
	PIN_FIELD_BASE(140, 140, 4, 0x0090, 0x10, 13, 1),
	PIN_FIELD_BASE(141, 141, 4, 0x0090, 0x10, 14, 1),
	PIN_FIELD_BASE(142, 142, 4, 0x0090, 0x10, 15, 1),
	PIN_FIELD_BASE(143, 143, 4, 0x0090, 0x10, 16, 1),
	PIN_FIELD_BASE(144, 144, 4, 0x0090, 0x10, 17, 1),
	PIN_FIELD_BASE(145, 145, 4, 0x0090, 0x10, 0, 1),
	PIN_FIELD_BASE(146, 146, 4, 0x0090, 0x10, 1, 1),
	PIN_FIELD_BASE(147, 147, 4, 0x0090, 0x10, 2, 1),
	PIN_FIELD_BASE(148, 148, 4, 0x0090, 0x10, 3, 1),
	PIN_FIELD_BASE(149, 149, 4, 0x0090, 0x10, 4, 1),
	PIN_FIELD_BASE(150, 150, 4, 0x0090, 0x10, 5, 1),
	PIN_FIELD_BASE(151, 151, 4, 0x0090, 0x10, 6, 1),
	PIN_FIELD_BASE(152, 152, 4, 0x0090, 0x10, 7, 1),
	PIN_FIELD_BASE(153, 153, 4, 0x0090, 0x10, 9, 1),
	PIN_FIELD_BASE(154, 154, 4, 0x0090, 0x10, 8, 1),
	PIN_FIELD_BASE(155, 155, 4, 0x0090, 0x10, 18, 1),
	PIN_FIELD_BASE(156, 156, 4, 0x0090, 0x10, 19, 1),
	PIN_FIELD_BASE(217, 217, 14, 0x00d0, 0x10, 1, 1),
	PIN_FIELD_BASE(218, 218, 14, 0x00d0, 0x10, 2, 1),
	PIN_FIELD_BASE(219, 219, 14, 0x00d0, 0x10, 0, 1),
	PIN_FIELD_BASE(224, 224, 14, 0x00d0, 0x10, 3, 1),
	PIN_FIELD_BASE(225, 225, 14, 0x00d0, 0x10, 4, 1),
	PIN_FIELD_BASE(226, 226, 14, 0x00d0, 0x10, 5, 1),
	PIN_FIELD_BASE(227, 227, 14, 0x00d0, 0x10, 6, 1),
	PIN_FIELD_BASE(228, 228, 14, 0x00d0, 0x10, 7, 1),
	PIN_FIELD_BASE(229, 229, 14, 0x00d0, 0x10, 8, 1),
	PIN_FIELD_BASE(259, 259, 14, 0x00d0, 0x10, 9, 1),
	PIN_FIELD_BASE(260, 260, 14, 0x00d0, 0x10, 10, 1),
	PIN_FIELD_BASE(261, 261, 14, 0x00d0, 0x10, 11, 1),
	PIN_FIELD_BASE(262, 262, 14, 0x00d0, 0x10, 12, 1),
	PIN_FIELD_BASE(263, 263, 14, 0x00d0, 0x10, 13, 1),
	PIN_FIELD_BASE(264, 264, 14, 0x00d0, 0x10, 14, 1),
	PIN_FIELD_BASE(265, 265, 14, 0x00d0, 0x10, 15, 1),
	PIN_FIELD_BASE(266, 266, 14, 0x00d0, 0x10, 16, 1),
	PIN_FIELD_BASE(267, 267, 15, 0x00b0, 0x10, 2, 1),
	PIN_FIELD_BASE(268, 268, 15, 0x00b0, 0x10, 3, 1),
	PIN_FIELD_BASE(269, 269, 15, 0x00b0, 0x10, 0, 1),
	PIN_FIELD_BASE(270, 270, 15, 0x00b0, 0x10, 1, 1),
};

static const struct mtk_pin_field_calc mt8196_pin_pu_range[] = {
	PIN_FIELD_BASE(0, 0, 8, 0x00a0, 0x10, 0, 1),
	PIN_FIELD_BASE(1, 1, 8, 0x00a0, 0x10, 1, 1),
	PIN_FIELD_BASE(2, 2, 11, 0x0080, 0x10, 1, 1),
	PIN_FIELD_BASE(3, 3, 11, 0x0080, 0x10, 2, 1),
	PIN_FIELD_BASE(4, 4, 11, 0x0080, 0x10, 3, 1),
	PIN_FIELD_BASE(5, 5, 11, 0x0080, 0x10, 4, 1),
	PIN_FIELD_BASE(6, 6, 11, 0x0080, 0x10, 5, 1),
	PIN_FIELD_BASE(7, 7, 11, 0x0080, 0x10, 6, 1),
	PIN_FIELD_BASE(8, 8, 11, 0x0080, 0x10, 7, 1),
	PIN_FIELD_BASE(9, 9, 9, 0x00c0, 0x10, 14, 1),
	PIN_FIELD_BASE(10, 10, 9, 0x00c0, 0x10, 12, 1),
	PIN_FIELD_BASE(11, 11, 8, 0x00a0, 0x10, 2, 1),
	PIN_FIELD_BASE(12, 12, 9, 0x00c0, 0x10, 13, 1),
	PIN_FIELD_BASE(13, 13, 6, 0x00b0, 0x10, 1, 1),
	PIN_FIELD_BASE(14, 14, 3, 0x0090, 0x10, 0, 1),
	PIN_FIELD_BASE(15, 15, 6, 0x00b0, 0x10, 2, 1),
	PIN_FIELD_BASE(16, 16, 6, 0x00b0, 0x10, 3, 1),
	PIN_FIELD_BASE(17, 17, 6, 0x00b0, 0x10, 4, 1),
	PIN_FIELD_BASE(18, 18, 6, 0x00b0, 0x10, 5, 1),
	PIN_FIELD_BASE(19, 19, 6, 0x00b0, 0x10, 6, 1),
	PIN_FIELD_BASE(20, 20, 3, 0x0090, 0x10, 1, 1),
	PIN_FIELD_BASE(21, 21, 2, 0x0090, 0x10, 3, 1),
	PIN_FIELD_BASE(22, 22, 2, 0x0090, 0x10, 4, 1),
	PIN_FIELD_BASE(23, 23, 2, 0x0090, 0x10, 5, 1),
	PIN_FIELD_BASE(24, 24, 2, 0x0090, 0x10, 6, 1),
	PIN_FIELD_BASE(25, 25, 2, 0x0090, 0x10, 7, 1),
	PIN_FIELD_BASE(26, 26, 2, 0x0090, 0x10, 8, 1),
	PIN_FIELD_BASE(27, 27, 2, 0x0090, 0x10, 9, 1),
	PIN_FIELD_BASE(28, 28, 2, 0x0090, 0x10, 10, 1),
	PIN_FIELD_BASE(29, 29, 2, 0x0090, 0x10, 11, 1),
	PIN_FIELD_BASE(30, 30, 2, 0x0090, 0x10, 12, 1),
	PIN_FIELD_BASE(31, 31, 2, 0x0090, 0x10, 13, 1),
	PIN_FIELD_BASE(32, 32, 1, 0x0090, 0x10, 8, 1),
	PIN_FIELD_BASE(33, 33, 1, 0x0090, 0x10, 9, 1),
	PIN_FIELD_BASE(34, 34, 1, 0x0090, 0x10, 10, 1),
	PIN_FIELD_BASE(35, 35, 1, 0x0090, 0x10, 11, 1),
	PIN_FIELD_BASE(36, 36, 1, 0x0090, 0x10, 12, 1),
	PIN_FIELD_BASE(37, 37, 1, 0x0090, 0x10, 13, 1),
	PIN_FIELD_BASE(38, 38, 1, 0x0090, 0x10, 14, 1),
	PIN_FIELD_BASE(39, 39, 8, 0x00a0, 0x10, 6, 1),
	PIN_FIELD_BASE(40, 40, 8, 0x00a0, 0x10, 3, 1),
	PIN_FIELD_BASE(41, 41, 8, 0x00a0, 0x10, 5, 1),
	PIN_FIELD_BASE(42, 42, 8, 0x00a0, 0x10, 4, 1),
	PIN_FIELD_BASE(43, 43, 8, 0x00a0, 0x10, 7, 1),
	PIN_FIELD_BASE(44, 44, 8, 0x00a0, 0x10, 8, 1),
	PIN_FIELD_BASE(45, 45, 8, 0x00a0, 0x10, 9, 1),
	PIN_FIELD_BASE(46, 46, 8, 0x00a0, 0x10, 10, 1),
	PIN_FIELD_BASE(47, 47, 8, 0x00a0, 0x10, 13, 1),
	PIN_FIELD_BASE(48, 48, 8, 0x00a0, 0x10, 11, 1),
	PIN_FIELD_BASE(49, 49, 8, 0x00a0, 0x10, 14, 1),
	PIN_FIELD_BASE(50, 50, 8, 0x00a0, 0x10, 12, 1),
	PIN_FIELD_BASE(51, 51, 8, 0x00a0, 0x10, 15, 1),
	PIN_FIELD_BASE(52, 52, 9, 0x00c0, 0x10, 7, 1),
	PIN_FIELD_BASE(53, 53, 9, 0x00c0, 0x10, 8, 1),
	PIN_FIELD_BASE(54, 54, 9, 0x00c0, 0x10, 2, 1),
	PIN_FIELD_BASE(55, 55, 9, 0x00c0, 0x10, 1, 1),
	PIN_FIELD_BASE(56, 56, 9, 0x00c0, 0x10, 5, 1),
	PIN_FIELD_BASE(57, 57, 9, 0x00c0, 0x10, 6, 1),
	PIN_FIELD_BASE(58, 58, 9, 0x00c0, 0x10, 3, 1),
	PIN_FIELD_BASE(59, 59, 9, 0x00c0, 0x10, 4, 1),
	PIN_FIELD_BASE(61, 61, 9, 0x00c0, 0x10, 10, 1),
	PIN_FIELD_BASE(62, 62, 9, 0x00c0, 0x10, 9, 1),
	PIN_FIELD_BASE(63, 63, 9, 0x00c0, 0x10, 18, 1),
	PIN_FIELD_BASE(64, 64, 9, 0x00c0, 0x10, 0, 1),
	PIN_FIELD_BASE(65, 65, 9, 0x00c0, 0x10, 11, 1),
	PIN_FIELD_BASE(66, 66, 9, 0x00c0, 0x10, 24, 1),
	PIN_FIELD_BASE(67, 67, 9, 0x00c0, 0x10, 21, 1),
	PIN_FIELD_BASE(68, 68, 9, 0x00c0, 0x10, 20, 1),
	PIN_FIELD_BASE(69, 69, 9, 0x00c0, 0x10, 25, 1),
	PIN_FIELD_BASE(70, 70, 9, 0x00c0, 0x10, 16, 1),
	PIN_FIELD_BASE(71, 71, 9, 0x00c0, 0x10, 15, 1),
	PIN_FIELD_BASE(72, 72, 9, 0x00c0, 0x10, 23, 1),
	PIN_FIELD_BASE(73, 73, 9, 0x00c0, 0x10, 19, 1),
	PIN_FIELD_BASE(74, 74, 9, 0x00c0, 0x10, 17, 1),
	PIN_FIELD_BASE(75, 75, 10, 0x0090, 0x10, 2, 1),
	PIN_FIELD_BASE(76, 76, 10, 0x0090, 0x10, 3, 1),
	PIN_FIELD_BASE(77, 77, 10, 0x0090, 0x10, 4, 1),
	PIN_FIELD_BASE(78, 78, 10, 0x0090, 0x10, 5, 1),
	PIN_FIELD_BASE(79, 79, 10, 0x0090, 0x10, 0, 1),
	PIN_FIELD_BASE(80, 80, 10, 0x0090, 0x10, 1, 1),
	PIN_FIELD_BASE(81, 81, 11, 0x0080, 0x10, 9, 1),
	PIN_FIELD_BASE(82, 82, 11, 0x0080, 0x10, 10, 1),
	PIN_FIELD_BASE(83, 83, 11, 0x0080, 0x10, 12, 1),
	PIN_FIELD_BASE(84, 84, 11, 0x0080, 0x10, 11, 1),
	PIN_FIELD_BASE(85, 85, 11, 0x0080, 0x10, 13, 1),
	PIN_FIELD_BASE(86, 86, 11, 0x0080, 0x10, 14, 1),
	PIN_FIELD_BASE(87, 87, 11, 0x0080, 0x10, 16, 1),
	PIN_FIELD_BASE(88, 88, 11, 0x0080, 0x10, 15, 1),
	PIN_FIELD_BASE(89, 89, 11, 0x0080, 0x10, 0, 1),
	PIN_FIELD_BASE(90, 90, 11, 0x0080, 0x10, 8, 1),
	PIN_FIELD_BASE(91, 91, 12, 0x0090, 0x10, 6, 1),
	PIN_FIELD_BASE(92, 92, 12, 0x0090, 0x10, 7, 1),
	PIN_FIELD_BASE(93, 93, 12, 0x0090, 0x10, 8, 1),
	PIN_FIELD_BASE(94, 94, 12, 0x0090, 0x10, 4, 1),
	PIN_FIELD_BASE(95, 95, 12, 0x0090, 0x10, 1, 1),
	PIN_FIELD_BASE(96, 96, 12, 0x0090, 0x10, 3, 1),
	PIN_FIELD_BASE(97, 97, 12, 0x0090, 0x10, 2, 1),
	PIN_FIELD_BASE(98, 98, 12, 0x0090, 0x10, 5, 1),
	PIN_FIELD_BASE(99, 99, 12, 0x0090, 0x10, 9, 1),
	PIN_FIELD_BASE(100, 100, 12, 0x0090, 0x10, 12, 1),
	PIN_FIELD_BASE(101, 101, 12, 0x0090, 0x10, 10, 1),
	PIN_FIELD_BASE(102, 102, 12, 0x0090, 0x10, 13, 1),
	PIN_FIELD_BASE(103, 103, 12, 0x0090, 0x10, 0, 1),
	PIN_FIELD_BASE(104, 104, 12, 0x0090, 0x10, 11, 1),
	PIN_FIELD_BASE(105, 105, 12, 0x0090, 0x10, 14, 1),
	PIN_FIELD_BASE(106, 106, 5, 0x0090, 0x10, 0, 1),
	PIN_FIELD_BASE(107, 107, 5, 0x0090, 0x10, 1, 1),
	PIN_FIELD_BASE(108, 108, 5, 0x0090, 0x10, 3, 1),
	PIN_FIELD_BASE(109, 109, 5, 0x0090, 0x10, 2, 1),
	PIN_FIELD_BASE(110, 110, 5, 0x0090, 0x10, 4, 1),
	PIN_FIELD_BASE(111, 111, 5, 0x0090, 0x10, 5, 1),
	PIN_FIELD_BASE(112, 112, 5, 0x0090, 0x10, 7, 1),
	PIN_FIELD_BASE(113, 113, 5, 0x0090, 0x10, 6, 1),
	PIN_FIELD_BASE(114, 114, 5, 0x0090, 0x10, 8, 1),
	PIN_FIELD_BASE(115, 115, 5, 0x0090, 0x10, 9, 1),
	PIN_FIELD_BASE(116, 116, 5, 0x0090, 0x10, 11, 1),
	PIN_FIELD_BASE(117, 117, 5, 0x0090, 0x10, 10, 1),
	PIN_FIELD_BASE(118, 118, 6, 0x00b0, 0x10, 9, 1),
	PIN_FIELD_BASE(119, 119, 6, 0x00b0, 0x10, 10, 1),
	PIN_FIELD_BASE(120, 120, 6, 0x00b0, 0x10, 12, 1),
	PIN_FIELD_BASE(121, 121, 6, 0x00b0, 0x10, 11, 1),
	PIN_FIELD_BASE(122, 122, 6, 0x00b0, 0x10, 0, 1),
	PIN_FIELD_BASE(123, 123, 6, 0x00b0, 0x10, 7, 1),
	PIN_FIELD_BASE(124, 124, 6, 0x00b0, 0x10, 8, 1),
	PIN_FIELD_BASE(157, 157, 2, 0x0090, 0x10, 1, 1),
	PIN_FIELD_BASE(158, 158, 2, 0x0090, 0x10, 2, 1),
	PIN_FIELD_BASE(159, 159, 2, 0x0090, 0x10, 0, 1),
	PIN_FIELD_BASE(160, 160, 3, 0x0090, 0x10, 22, 1),
	PIN_FIELD_BASE(161, 161, 3, 0x0090, 0x10, 20, 1),
	PIN_FIELD_BASE(162, 162, 3, 0x0090, 0x10, 23, 1),
	PIN_FIELD_BASE(163, 163, 3, 0x0090, 0x10, 21, 1),
	PIN_FIELD_BASE(164, 164, 3, 0x0090, 0x10, 12, 1),
	PIN_FIELD_BASE(165, 165, 3, 0x0090, 0x10, 14, 1),
	PIN_FIELD_BASE(166, 166, 3, 0x0090, 0x10, 13, 1),
	PIN_FIELD_BASE(167, 167, 3, 0x0090, 0x10, 15, 1),
	PIN_FIELD_BASE(168, 168, 3, 0x0090, 0x10, 16, 1),
	PIN_FIELD_BASE(169, 169, 3, 0x0090, 0x10, 17, 1),
	PIN_FIELD_BASE(170, 170, 3, 0x0090, 0x10, 19, 1),
	PIN_FIELD_BASE(171, 171, 3, 0x0090, 0x10, 18, 1),
	PIN_FIELD_BASE(172, 172, 3, 0x0090, 0x10, 10, 1),
	PIN_FIELD_BASE(173, 173, 3, 0x0090, 0x10, 11, 1),
	PIN_FIELD_BASE(174, 174, 1, 0x0090, 0x10, 15, 1),
	PIN_FIELD_BASE(175, 175, 1, 0x0090, 0x10, 16, 1),
	PIN_FIELD_BASE(176, 176, 1, 0x0090, 0x10, 17, 1),
	PIN_FIELD_BASE(177, 177, 1, 0x0090, 0x10, 18, 1),
	PIN_FIELD_BASE(178, 178, 1, 0x0090, 0x10, 6, 1),
	PIN_FIELD_BASE(179, 179, 1, 0x0090, 0x10, 7, 1),
	PIN_FIELD_BASE(180, 180, 1, 0x0090, 0x10, 0, 1),
	PIN_FIELD_BASE(181, 181, 1, 0x0090, 0x10, 1, 1),
	PIN_FIELD_BASE(182, 182, 1, 0x0090, 0x10, 2, 1),
	PIN_FIELD_BASE(183, 183, 1, 0x0090, 0x10, 3, 1),
	PIN_FIELD_BASE(184, 184, 1, 0x0090, 0x10, 4, 1),
	PIN_FIELD_BASE(185, 185, 1, 0x0090, 0x10, 5, 1),
	PIN_FIELD_BASE(186, 186, 13, 0x00d0, 0x10, 4, 1),
	PIN_FIELD_BASE(187, 187, 13, 0x00d0, 0x10, 5, 1),
	PIN_FIELD_BASE(188, 188, 13, 0x00d0, 0x10, 12, 1),
	PIN_FIELD_BASE(189, 189, 13, 0x00d0, 0x10, 17, 1),
	PIN_FIELD_BASE(190, 190, 13, 0x00d0, 0x10, 13, 1),
	PIN_FIELD_BASE(191, 191, 13, 0x00d0, 0x10, 18, 1),
	PIN_FIELD_BASE(192, 192, 13, 0x00d0, 0x10, 0, 1),
	PIN_FIELD_BASE(193, 193, 13, 0x00d0, 0x10, 6, 1),
	PIN_FIELD_BASE(194, 194, 13, 0x00d0, 0x10, 14, 1),
	PIN_FIELD_BASE(195, 195, 13, 0x00d0, 0x10, 19, 1),
	PIN_FIELD_BASE(196, 196, 13, 0x00d0, 0x10, 1, 1),
	PIN_FIELD_BASE(197, 197, 13, 0x00d0, 0x10, 7, 1),
	PIN_FIELD_BASE(198, 198, 13, 0x00d0, 0x10, 15, 1),
	PIN_FIELD_BASE(199, 199, 13, 0x00d0, 0x10, 20, 1),
	PIN_FIELD_BASE(200, 200, 13, 0x00d0, 0x10, 22, 1),
	PIN_FIELD_BASE(201, 201, 13, 0x00d0, 0x10, 25, 1),
	PIN_FIELD_BASE(202, 202, 13, 0x00d0, 0x10, 16, 1),
	PIN_FIELD_BASE(203, 203, 13, 0x00d0, 0x10, 21, 1),
	PIN_FIELD_BASE(204, 204, 13, 0x00d0, 0x10, 2, 1),
	PIN_FIELD_BASE(205, 205, 13, 0x00d0, 0x10, 3, 1),
	PIN_FIELD_BASE(206, 206, 13, 0x00d0, 0x10, 8, 1),
	PIN_FIELD_BASE(207, 207, 13, 0x00d0, 0x10, 9, 1),
	PIN_FIELD_BASE(208, 208, 13, 0x00d0, 0x10, 10, 1),
	PIN_FIELD_BASE(209, 209, 13, 0x00d0, 0x10, 11, 1),
	PIN_FIELD_BASE(210, 210, 14, 0x00b0, 0x10, 0, 1),
	PIN_FIELD_BASE(211, 211, 14, 0x00b0, 0x10, 1, 1),
	PIN_FIELD_BASE(212, 212, 14, 0x00b0, 0x10, 2, 1),
	PIN_FIELD_BASE(213, 213, 14, 0x00b0, 0x10, 3, 1),
	PIN_FIELD_BASE(214, 214, 13, 0x00d0, 0x10, 23, 1),
	PIN_FIELD_BASE(215, 215, 13, 0x00d0, 0x10, 24, 1),
	PIN_FIELD_BASE(216, 216, 14, 0x00b0, 0x10, 4, 1),
	PIN_FIELD_BASE(220, 220, 14, 0x00b0, 0x10, 5, 1),
	PIN_FIELD_BASE(221, 221, 14, 0x00b0, 0x10, 6, 1),
	PIN_FIELD_BASE(222, 222, 14, 0x00b0, 0x10, 8, 1),
	PIN_FIELD_BASE(223, 223, 14, 0x00b0, 0x10, 7, 1),
	PIN_FIELD_BASE(230, 230, 15, 0x0090, 0x10, 13, 1),
	PIN_FIELD_BASE(231, 231, 15, 0x0090, 0x10, 14, 1),
	PIN_FIELD_BASE(232, 232, 15, 0x0090, 0x10, 10, 1),
	PIN_FIELD_BASE(233, 233, 15, 0x0090, 0x10, 0, 1),
	PIN_FIELD_BASE(234, 234, 15, 0x0090, 0x10, 3, 1),
	PIN_FIELD_BASE(235, 235, 15, 0x0090, 0x10, 1, 1),
	PIN_FIELD_BASE(236, 236, 15, 0x0090, 0x10, 2, 1),
	PIN_FIELD_BASE(237, 237, 15, 0x0090, 0x10, 6, 1),
	PIN_FIELD_BASE(238, 238, 15, 0x0090, 0x10, 5, 1),
	PIN_FIELD_BASE(239, 239, 15, 0x0090, 0x10, 19, 1),
	PIN_FIELD_BASE(240, 240, 15, 0x0090, 0x10, 18, 1),
	PIN_FIELD_BASE(241, 241, 15, 0x0090, 0x10, 16, 1),
	PIN_FIELD_BASE(242, 242, 15, 0x0090, 0x10, 17, 1),
	PIN_FIELD_BASE(243, 243, 15, 0x0090, 0x10, 15, 1),
	PIN_FIELD_BASE(244, 244, 15, 0x0090, 0x10, 12, 1),
	PIN_FIELD_BASE(245, 245, 15, 0x0090, 0x10, 9, 1),
	PIN_FIELD_BASE(246, 246, 15, 0x0090, 0x10, 8, 1),
	PIN_FIELD_BASE(247, 247, 15, 0x0090, 0x10, 7, 1),
	PIN_FIELD_BASE(248, 248, 15, 0x0090, 0x10, 4, 1),
	PIN_FIELD_BASE(249, 249, 15, 0x0090, 0x10, 20, 1),
	PIN_FIELD_BASE(250, 250, 15, 0x0090, 0x10, 11, 1),
	PIN_FIELD_BASE(251, 251, 3, 0x0090, 0x10, 2, 1),
	PIN_FIELD_BASE(252, 252, 3, 0x0090, 0x10, 3, 1),
	PIN_FIELD_BASE(253, 253, 3, 0x0090, 0x10, 4, 1),
	PIN_FIELD_BASE(254, 254, 3, 0x0090, 0x10, 5, 1),
	PIN_FIELD_BASE(255, 255, 3, 0x0090, 0x10, 6, 1),
	PIN_FIELD_BASE(256, 256, 3, 0x0090, 0x10, 7, 1),
	PIN_FIELD_BASE(257, 257, 3, 0x0090, 0x10, 8, 1),
	PIN_FIELD_BASE(258, 258, 3, 0x0090, 0x10, 9, 1),
};

static const struct mtk_pin_field_calc mt8196_pin_pd_range[] = {
	PIN_FIELD_BASE(0, 0, 8, 0x0090, 0x10, 0, 1),
	PIN_FIELD_BASE(1, 1, 8, 0x0090, 0x10, 1, 1),
	PIN_FIELD_BASE(2, 2, 11, 0x0070, 0x10, 1, 1),
	PIN_FIELD_BASE(3, 3, 11, 0x0070, 0x10, 2, 1),
	PIN_FIELD_BASE(4, 4, 11, 0x0070, 0x10, 3, 1),
	PIN_FIELD_BASE(5, 5, 11, 0x0070, 0x10, 4, 1),
	PIN_FIELD_BASE(6, 6, 11, 0x0070, 0x10, 5, 1),
	PIN_FIELD_BASE(7, 7, 11, 0x0070, 0x10, 6, 1),
	PIN_FIELD_BASE(8, 8, 11, 0x0070, 0x10, 7, 1),
	PIN_FIELD_BASE(9, 9, 9, 0x00a0, 0x10, 14, 1),
	PIN_FIELD_BASE(10, 10, 9, 0x00a0, 0x10, 12, 1),
	PIN_FIELD_BASE(11, 11, 8, 0x0090, 0x10, 2, 1),
	PIN_FIELD_BASE(12, 12, 9, 0x00a0, 0x10, 13, 1),
	PIN_FIELD_BASE(13, 13, 6, 0x0090, 0x10, 1, 1),
	PIN_FIELD_BASE(14, 14, 3, 0x0080, 0x10, 0, 1),
	PIN_FIELD_BASE(15, 15, 6, 0x0090, 0x10, 2, 1),
	PIN_FIELD_BASE(16, 16, 6, 0x0090, 0x10, 3, 1),
	PIN_FIELD_BASE(17, 17, 6, 0x0090, 0x10, 4, 1),
	PIN_FIELD_BASE(18, 18, 6, 0x0090, 0x10, 5, 1),
	PIN_FIELD_BASE(19, 19, 6, 0x0090, 0x10, 6, 1),
	PIN_FIELD_BASE(20, 20, 3, 0x0080, 0x10, 1, 1),
	PIN_FIELD_BASE(21, 21, 2, 0x0080, 0x10, 3, 1),
	PIN_FIELD_BASE(22, 22, 2, 0x0080, 0x10, 4, 1),
	PIN_FIELD_BASE(23, 23, 2, 0x0080, 0x10, 5, 1),
	PIN_FIELD_BASE(24, 24, 2, 0x0080, 0x10, 6, 1),
	PIN_FIELD_BASE(25, 25, 2, 0x0080, 0x10, 7, 1),
	PIN_FIELD_BASE(26, 26, 2, 0x0080, 0x10, 8, 1),
	PIN_FIELD_BASE(27, 27, 2, 0x0080, 0x10, 9, 1),
	PIN_FIELD_BASE(28, 28, 2, 0x0080, 0x10, 10, 1),
	PIN_FIELD_BASE(29, 29, 2, 0x0080, 0x10, 11, 1),
	PIN_FIELD_BASE(30, 30, 2, 0x0080, 0x10, 12, 1),
	PIN_FIELD_BASE(31, 31, 2, 0x0080, 0x10, 13, 1),
	PIN_FIELD_BASE(32, 32, 1, 0x0080, 0x10, 8, 1),
	PIN_FIELD_BASE(33, 33, 1, 0x0080, 0x10, 9, 1),
	PIN_FIELD_BASE(34, 34, 1, 0x0080, 0x10, 10, 1),
	PIN_FIELD_BASE(35, 35, 1, 0x0080, 0x10, 11, 1),
	PIN_FIELD_BASE(36, 36, 1, 0x0080, 0x10, 12, 1),
	PIN_FIELD_BASE(37, 37, 1, 0x0080, 0x10, 13, 1),
	PIN_FIELD_BASE(38, 38, 1, 0x0080, 0x10, 14, 1),
	PIN_FIELD_BASE(39, 39, 8, 0x0090, 0x10, 6, 1),
	PIN_FIELD_BASE(40, 40, 8, 0x0090, 0x10, 3, 1),
	PIN_FIELD_BASE(41, 41, 8, 0x0090, 0x10, 5, 1),
	PIN_FIELD_BASE(42, 42, 8, 0x0090, 0x10, 4, 1),
	PIN_FIELD_BASE(43, 43, 8, 0x0090, 0x10, 7, 1),
	PIN_FIELD_BASE(44, 44, 8, 0x0090, 0x10, 8, 1),
	PIN_FIELD_BASE(45, 45, 8, 0x0090, 0x10, 9, 1),
	PIN_FIELD_BASE(46, 46, 8, 0x0090, 0x10, 10, 1),
	PIN_FIELD_BASE(47, 47, 8, 0x0090, 0x10, 13, 1),
	PIN_FIELD_BASE(48, 48, 8, 0x0090, 0x10, 11, 1),
	PIN_FIELD_BASE(49, 49, 8, 0x0090, 0x10, 14, 1),
	PIN_FIELD_BASE(50, 50, 8, 0x0090, 0x10, 12, 1),
	PIN_FIELD_BASE(51, 51, 8, 0x0090, 0x10, 15, 1),
	PIN_FIELD_BASE(52, 52, 9, 0x00a0, 0x10, 7, 1),
	PIN_FIELD_BASE(53, 53, 9, 0x00a0, 0x10, 8, 1),
	PIN_FIELD_BASE(54, 54, 9, 0x00a0, 0x10, 2, 1),
	PIN_FIELD_BASE(55, 55, 9, 0x00a0, 0x10, 1, 1),
	PIN_FIELD_BASE(56, 56, 9, 0x00a0, 0x10, 5, 1),
	PIN_FIELD_BASE(57, 57, 9, 0x00a0, 0x10, 6, 1),
	PIN_FIELD_BASE(58, 58, 9, 0x00a0, 0x10, 3, 1),
	PIN_FIELD_BASE(59, 59, 9, 0x00a0, 0x10, 4, 1),
	PIN_FIELD_BASE(61, 61, 9, 0x00a0, 0x10, 10, 1),
	PIN_FIELD_BASE(62, 62, 9, 0x00a0, 0x10, 9, 1),
	PIN_FIELD_BASE(63, 63, 9, 0x00a0, 0x10, 18, 1),
	PIN_FIELD_BASE(64, 64, 9, 0x00a0, 0x10, 0, 1),
	PIN_FIELD_BASE(65, 65, 9, 0x00a0, 0x10, 11, 1),
	PIN_FIELD_BASE(66, 66, 9, 0x00a0, 0x10, 24, 1),
	PIN_FIELD_BASE(67, 67, 9, 0x00a0, 0x10, 21, 1),
	PIN_FIELD_BASE(68, 68, 9, 0x00a0, 0x10, 20, 1),
	PIN_FIELD_BASE(69, 69, 9, 0x00a0, 0x10, 25, 1),
	PIN_FIELD_BASE(70, 70, 9, 0x00a0, 0x10, 16, 1),
	PIN_FIELD_BASE(71, 71, 9, 0x00a0, 0x10, 15, 1),
	PIN_FIELD_BASE(72, 72, 9, 0x00a0, 0x10, 23, 1),
	PIN_FIELD_BASE(73, 73, 9, 0x00a0, 0x10, 19, 1),
	PIN_FIELD_BASE(74, 74, 9, 0x00a0, 0x10, 17, 1),
	PIN_FIELD_BASE(75, 75, 10, 0x0080, 0x10, 2, 1),
	PIN_FIELD_BASE(76, 76, 10, 0x0080, 0x10, 3, 1),
	PIN_FIELD_BASE(77, 77, 10, 0x0080, 0x10, 4, 1),
	PIN_FIELD_BASE(78, 78, 10, 0x0080, 0x10, 5, 1),
	PIN_FIELD_BASE(79, 79, 10, 0x0080, 0x10, 0, 1),
	PIN_FIELD_BASE(80, 80, 10, 0x0080, 0x10, 1, 1),
	PIN_FIELD_BASE(81, 81, 11, 0x0070, 0x10, 9, 1),
	PIN_FIELD_BASE(82, 82, 11, 0x0070, 0x10, 10, 1),
	PIN_FIELD_BASE(83, 83, 11, 0x0070, 0x10, 12, 1),
	PIN_FIELD_BASE(84, 84, 11, 0x0070, 0x10, 11, 1),
	PIN_FIELD_BASE(85, 85, 11, 0x0070, 0x10, 13, 1),
	PIN_FIELD_BASE(86, 86, 11, 0x0070, 0x10, 14, 1),
	PIN_FIELD_BASE(87, 87, 11, 0x0070, 0x10, 16, 1),
	PIN_FIELD_BASE(88, 88, 11, 0x0070, 0x10, 15, 1),
	PIN_FIELD_BASE(89, 89, 11, 0x0070, 0x10, 0, 1),
	PIN_FIELD_BASE(90, 90, 11, 0x0070, 0x10, 8, 1),
	PIN_FIELD_BASE(91, 91, 12, 0x0080, 0x10, 6, 1),
	PIN_FIELD_BASE(92, 92, 12, 0x0080, 0x10, 7, 1),
	PIN_FIELD_BASE(93, 93, 12, 0x0080, 0x10, 8, 1),
	PIN_FIELD_BASE(94, 94, 12, 0x0080, 0x10, 4, 1),
	PIN_FIELD_BASE(95, 95, 12, 0x0080, 0x10, 1, 1),
	PIN_FIELD_BASE(96, 96, 12, 0x0080, 0x10, 3, 1),
	PIN_FIELD_BASE(97, 97, 12, 0x0080, 0x10, 2, 1),
	PIN_FIELD_BASE(98, 98, 12, 0x0080, 0x10, 5, 1),
	PIN_FIELD_BASE(99, 99, 12, 0x0080, 0x10, 9, 1),
	PIN_FIELD_BASE(100, 100, 12, 0x0080, 0x10, 12, 1),
	PIN_FIELD_BASE(101, 101, 12, 0x0080, 0x10, 10, 1),
	PIN_FIELD_BASE(102, 102, 12, 0x0080, 0x10, 13, 1),
	PIN_FIELD_BASE(103, 103, 12, 0x0080, 0x10, 0, 1),
	PIN_FIELD_BASE(104, 104, 12, 0x0080, 0x10, 11, 1),
	PIN_FIELD_BASE(105, 105, 12, 0x0080, 0x10, 14, 1),
	PIN_FIELD_BASE(106, 106, 5, 0x0080, 0x10, 0, 1),
	PIN_FIELD_BASE(107, 107, 5, 0x0080, 0x10, 1, 1),
	PIN_FIELD_BASE(108, 108, 5, 0x0080, 0x10, 3, 1),
	PIN_FIELD_BASE(109, 109, 5, 0x0080, 0x10, 2, 1),
	PIN_FIELD_BASE(110, 110, 5, 0x0080, 0x10, 4, 1),
	PIN_FIELD_BASE(111, 111, 5, 0x0080, 0x10, 5, 1),
	PIN_FIELD_BASE(112, 112, 5, 0x0080, 0x10, 7, 1),
	PIN_FIELD_BASE(113, 113, 5, 0x0080, 0x10, 6, 1),
	PIN_FIELD_BASE(114, 114, 5, 0x0080, 0x10, 8, 1),
	PIN_FIELD_BASE(115, 115, 5, 0x0080, 0x10, 9, 1),
	PIN_FIELD_BASE(116, 116, 5, 0x0080, 0x10, 11, 1),
	PIN_FIELD_BASE(117, 117, 5, 0x0080, 0x10, 10, 1),
	PIN_FIELD_BASE(118, 118, 6, 0x0090, 0x10, 9, 1),
	PIN_FIELD_BASE(119, 119, 6, 0x0090, 0x10, 10, 1),
	PIN_FIELD_BASE(120, 120, 6, 0x0090, 0x10, 12, 1),
	PIN_FIELD_BASE(121, 121, 6, 0x0090, 0x10, 11, 1),
	PIN_FIELD_BASE(122, 122, 6, 0x0090, 0x10, 0, 1),
	PIN_FIELD_BASE(123, 123, 6, 0x0090, 0x10, 7, 1),
	PIN_FIELD_BASE(124, 124, 6, 0x0090, 0x10, 8, 1),
	PIN_FIELD_BASE(157, 157, 2, 0x0080, 0x10, 1, 1),
	PIN_FIELD_BASE(158, 158, 2, 0x0080, 0x10, 2, 1),
	PIN_FIELD_BASE(159, 159, 2, 0x0080, 0x10, 0, 1),
	PIN_FIELD_BASE(160, 160, 3, 0x0080, 0x10, 22, 1),
	PIN_FIELD_BASE(161, 161, 3, 0x0080, 0x10, 20, 1),
	PIN_FIELD_BASE(162, 162, 3, 0x0080, 0x10, 23, 1),
	PIN_FIELD_BASE(163, 163, 3, 0x0080, 0x10, 21, 1),
	PIN_FIELD_BASE(164, 164, 3, 0x0080, 0x10, 12, 1),
	PIN_FIELD_BASE(165, 165, 3, 0x0080, 0x10, 14, 1),
	PIN_FIELD_BASE(166, 166, 3, 0x0080, 0x10, 13, 1),
	PIN_FIELD_BASE(167, 167, 3, 0x0080, 0x10, 15, 1),
	PIN_FIELD_BASE(168, 168, 3, 0x0080, 0x10, 16, 1),
	PIN_FIELD_BASE(169, 169, 3, 0x0080, 0x10, 17, 1),
	PIN_FIELD_BASE(170, 170, 3, 0x0080, 0x10, 19, 1),
	PIN_FIELD_BASE(171, 171, 3, 0x0080, 0x10, 18, 1),
	PIN_FIELD_BASE(172, 172, 3, 0x0080, 0x10, 10, 1),
	PIN_FIELD_BASE(173, 173, 3, 0x0080, 0x10, 11, 1),
	PIN_FIELD_BASE(174, 174, 1, 0x0080, 0x10, 15, 1),
	PIN_FIELD_BASE(175, 175, 1, 0x0080, 0x10, 16, 1),
	PIN_FIELD_BASE(176, 176, 1, 0x0080, 0x10, 17, 1),
	PIN_FIELD_BASE(177, 177, 1, 0x0080, 0x10, 18, 1),
	PIN_FIELD_BASE(178, 178, 1, 0x0080, 0x10, 6, 1),
	PIN_FIELD_BASE(179, 179, 1, 0x0080, 0x10, 7, 1),
	PIN_FIELD_BASE(180, 180, 1, 0x0080, 0x10, 0, 1),
	PIN_FIELD_BASE(181, 181, 1, 0x0080, 0x10, 1, 1),
	PIN_FIELD_BASE(182, 182, 1, 0x0080, 0x10, 2, 1),
	PIN_FIELD_BASE(183, 183, 1, 0x0080, 0x10, 3, 1),
	PIN_FIELD_BASE(184, 184, 1, 0x0080, 0x10, 4, 1),
	PIN_FIELD_BASE(185, 185, 1, 0x0080, 0x10, 5, 1),
	PIN_FIELD_BASE(186, 186, 13, 0x00c0, 0x10, 4, 1),
	PIN_FIELD_BASE(187, 187, 13, 0x00c0, 0x10, 5, 1),
	PIN_FIELD_BASE(188, 188, 13, 0x00c0, 0x10, 12, 1),
	PIN_FIELD_BASE(189, 189, 13, 0x00c0, 0x10, 17, 1),
	PIN_FIELD_BASE(190, 190, 13, 0x00c0, 0x10, 13, 1),
	PIN_FIELD_BASE(191, 191, 13, 0x00c0, 0x10, 18, 1),
	PIN_FIELD_BASE(192, 192, 13, 0x00c0, 0x10, 0, 1),
	PIN_FIELD_BASE(193, 193, 13, 0x00c0, 0x10, 6, 1),
	PIN_FIELD_BASE(194, 194, 13, 0x00c0, 0x10, 14, 1),
	PIN_FIELD_BASE(195, 195, 13, 0x00c0, 0x10, 19, 1),
	PIN_FIELD_BASE(196, 196, 13, 0x00c0, 0x10, 1, 1),
	PIN_FIELD_BASE(197, 197, 13, 0x00c0, 0x10, 7, 1),
	PIN_FIELD_BASE(198, 198, 13, 0x00c0, 0x10, 15, 1),
	PIN_FIELD_BASE(199, 199, 13, 0x00c0, 0x10, 20, 1),
	PIN_FIELD_BASE(200, 200, 13, 0x00c0, 0x10, 22, 1),
	PIN_FIELD_BASE(201, 201, 13, 0x00c0, 0x10, 25, 1),
	PIN_FIELD_BASE(202, 202, 13, 0x00c0, 0x10, 16, 1),
	PIN_FIELD_BASE(203, 203, 13, 0x00c0, 0x10, 21, 1),
	PIN_FIELD_BASE(204, 204, 13, 0x00c0, 0x10, 2, 1),
	PIN_FIELD_BASE(205, 205, 13, 0x00c0, 0x10, 3, 1),
	PIN_FIELD_BASE(206, 206, 13, 0x00c0, 0x10, 8, 1),
	PIN_FIELD_BASE(207, 207, 13, 0x00c0, 0x10, 9, 1),
	PIN_FIELD_BASE(208, 208, 13, 0x00c0, 0x10, 10, 1),
	PIN_FIELD_BASE(209, 209, 13, 0x00c0, 0x10, 11, 1),
	PIN_FIELD_BASE(210, 210, 14, 0x0090, 0x10, 0, 1),
	PIN_FIELD_BASE(211, 211, 14, 0x0090, 0x10, 1, 1),
	PIN_FIELD_BASE(212, 212, 14, 0x0090, 0x10, 2, 1),
	PIN_FIELD_BASE(213, 213, 14, 0x0090, 0x10, 3, 1),
	PIN_FIELD_BASE(214, 214, 13, 0x00c0, 0x10, 23, 1),
	PIN_FIELD_BASE(215, 215, 13, 0x00c0, 0x10, 24, 1),
	PIN_FIELD_BASE(216, 216, 14, 0x0090, 0x10, 4, 1),
	PIN_FIELD_BASE(220, 220, 14, 0x0090, 0x10, 5, 1),
	PIN_FIELD_BASE(221, 221, 14, 0x0090, 0x10, 6, 1),
	PIN_FIELD_BASE(222, 222, 14, 0x0090, 0x10, 8, 1),
	PIN_FIELD_BASE(223, 223, 14, 0x0090, 0x10, 7, 1),
	PIN_FIELD_BASE(230, 230, 15, 0x0070, 0x10, 13, 1),
	PIN_FIELD_BASE(231, 231, 15, 0x0070, 0x10, 14, 1),
	PIN_FIELD_BASE(232, 232, 15, 0x0070, 0x10, 10, 1),
	PIN_FIELD_BASE(233, 233, 15, 0x0070, 0x10, 0, 1),
	PIN_FIELD_BASE(234, 234, 15, 0x0070, 0x10, 3, 1),
	PIN_FIELD_BASE(235, 235, 15, 0x0070, 0x10, 1, 1),
	PIN_FIELD_BASE(236, 236, 15, 0x0070, 0x10, 2, 1),
	PIN_FIELD_BASE(237, 237, 15, 0x0070, 0x10, 6, 1),
	PIN_FIELD_BASE(238, 238, 15, 0x0070, 0x10, 5, 1),
	PIN_FIELD_BASE(239, 239, 15, 0x0070, 0x10, 19, 1),
	PIN_FIELD_BASE(240, 240, 15, 0x0070, 0x10, 18, 1),
	PIN_FIELD_BASE(241, 241, 15, 0x0070, 0x10, 16, 1),
	PIN_FIELD_BASE(242, 242, 15, 0x0070, 0x10, 17, 1),
	PIN_FIELD_BASE(243, 243, 15, 0x0070, 0x10, 15, 1),
	PIN_FIELD_BASE(244, 244, 15, 0x0070, 0x10, 12, 1),
	PIN_FIELD_BASE(245, 245, 15, 0x0070, 0x10, 9, 1),
	PIN_FIELD_BASE(246, 246, 15, 0x0070, 0x10, 8, 1),
	PIN_FIELD_BASE(247, 247, 15, 0x0070, 0x10, 7, 1),
	PIN_FIELD_BASE(248, 248, 15, 0x0070, 0x10, 4, 1),
	PIN_FIELD_BASE(249, 249, 15, 0x0070, 0x10, 20, 1),
	PIN_FIELD_BASE(250, 250, 15, 0x0070, 0x10, 11, 1),
	PIN_FIELD_BASE(251, 251, 3, 0x0080, 0x10, 2, 1),
	PIN_FIELD_BASE(252, 252, 3, 0x0080, 0x10, 3, 1),
	PIN_FIELD_BASE(253, 253, 3, 0x0080, 0x10, 4, 1),
	PIN_FIELD_BASE(254, 254, 3, 0x0080, 0x10, 5, 1),
	PIN_FIELD_BASE(255, 255, 3, 0x0080, 0x10, 6, 1),
	PIN_FIELD_BASE(256, 256, 3, 0x0080, 0x10, 7, 1),
	PIN_FIELD_BASE(257, 257, 3, 0x0080, 0x10, 8, 1),
	PIN_FIELD_BASE(258, 258, 3, 0x0080, 0x10, 9, 1),
};

static const struct mtk_pin_field_calc mt8196_pin_drv_range[] = {
	PIN_FIELD_BASE(0, 0, 8, 0x0000, 0x10, 0, 3),
	PIN_FIELD_BASE(1, 1, 8, 0x0000, 0x10, 3, 3),
	PIN_FIELD_BASE(2, 2, 11, 0x0000, 0x10, 12, 3),
	PIN_FIELD_BASE(3, 3, 11, 0x0000, 0x10, 12, 3),
	PIN_FIELD_BASE(4, 4, 11, 0x0000, 0x10, 15, 3),
	PIN_FIELD_BASE(5, 5, 11, 0x0000, 0x10, 0, 3),
	PIN_FIELD_BASE(6, 6, 11, 0x0000, 0x10, 3, 3),
	PIN_FIELD_BASE(7, 7, 11, 0x0000, 0x10, 6, 3),
	PIN_FIELD_BASE(8, 8, 11, 0x0000, 0x10, 9, 3),
	PIN_FIELD_BASE(9, 9, 9, 0x0010, 0x10, 9, 3),
	PIN_FIELD_BASE(10, 10, 9, 0x0010, 0x10, 6, 3),
	PIN_FIELD_BASE(11, 11, 8, 0x0000, 0x10, 24, 3),
	PIN_FIELD_BASE(12, 12, 9, 0x0010, 0x10, 15, 3),
	PIN_FIELD_BASE(13, 13, 6, 0x0000, 0x10, 9, 3),
	PIN_FIELD_BASE(14, 14, 3, 0x0000, 0x10, 0, 3),
	PIN_FIELD_BASE(15, 15, 6, 0x0000, 0x10, 0, 3),
	PIN_FIELD_BASE(16, 16, 6, 0x0000, 0x10, 9, 3),
	PIN_FIELD_BASE(17, 17, 6, 0x0000, 0x10, 9, 3),
	PIN_FIELD_BASE(18, 18, 6, 0x0000, 0x10, 3, 3),
	PIN_FIELD_BASE(19, 19, 6, 0x0000, 0x10, 6, 3),
	PIN_FIELD_BASE(20, 20, 3, 0x0000, 0x10, 9, 3),
	PIN_FIELD_BASE(21, 21, 2, 0x0000, 0x10, 0, 3),
	PIN_FIELD_BASE(22, 22, 2, 0x0000, 0x10, 3, 3),
	PIN_FIELD_BASE(23, 23, 2, 0x0000, 0x10, 6, 3),
	PIN_FIELD_BASE(24, 24, 2, 0x0000, 0x10, 9, 3),
	PIN_FIELD_BASE(25, 25, 2, 0x0000, 0x10, 12, 3),
	PIN_FIELD_BASE(26, 26, 2, 0x0000, 0x10, 15, 3),
	PIN_FIELD_BASE(27, 27, 2, 0x0010, 0x10, 3, 3),
	PIN_FIELD_BASE(28, 28, 2, 0x0000, 0x10, 18, 3),
	PIN_FIELD_BASE(29, 29, 2, 0x0000, 0x10, 21, 3),
	PIN_FIELD_BASE(30, 30, 2, 0x0000, 0x10, 24, 3),
	PIN_FIELD_BASE(31, 31, 2, 0x0000, 0x10, 27, 3),
	PIN_FIELD_BASE(32, 32, 1, 0x0000, 0x10, 21, 3),
	PIN_FIELD_BASE(33, 33, 1, 0x0000, 0x10, 21, 3),
	PIN_FIELD_BASE(34, 34, 1, 0x0000, 0x10, 21, 3),
	PIN_FIELD_BASE(35, 35, 1, 0x0000, 0x10, 21, 3),
	PIN_FIELD_BASE(36, 36, 1, 0x0000, 0x10, 21, 3),
	PIN_FIELD_BASE(37, 37, 1, 0x0000, 0x10, 27, 3),
	PIN_FIELD_BASE(38, 38, 1, 0x0000, 0x10, 18, 3),
	PIN_FIELD_BASE(39, 39, 8, 0x0000, 0x10, 27, 3),
	PIN_FIELD_BASE(40, 40, 8, 0x0000, 0x10, 6, 3),
	PIN_FIELD_BASE(41, 41, 8, 0x0000, 0x10, 12, 3),
	PIN_FIELD_BASE(42, 42, 8, 0x0000, 0x10, 9, 3),
	PIN_FIELD_BASE(43, 43, 8, 0x0000, 0x10, 15, 3),
	PIN_FIELD_BASE(44, 44, 8, 0x0000, 0x10, 18, 3),
	PIN_FIELD_BASE(45, 45, 8, 0x0000, 0x10, 21, 3),
	PIN_FIELD_BASE(46, 46, 8, 0x0010, 0x10, 0, 3),
	PIN_FIELD_BASE(47, 47, 8, 0x0010, 0x10, 9, 3),
	PIN_FIELD_BASE(48, 48, 8, 0x0010, 0x10, 3, 3),
	PIN_FIELD_BASE(49, 49, 8, 0x0010, 0x10, 12, 3),
	PIN_FIELD_BASE(50, 50, 8, 0x0010, 0x10, 6, 3),
	PIN_FIELD_BASE(51, 51, 8, 0x0010, 0x10, 15, 3),
	PIN_FIELD_BASE(52, 52, 9, 0x0000, 0x10, 21, 3),
	PIN_FIELD_BASE(53, 53, 9, 0x0000, 0x10, 24, 3),
	PIN_FIELD_BASE(54, 54, 9, 0x0000, 0x10, 6, 3),
	PIN_FIELD_BASE(55, 55, 9, 0x0000, 0x10, 3, 3),
	PIN_FIELD_BASE(56, 56, 9, 0x0000, 0x10, 15, 3),
	PIN_FIELD_BASE(57, 57, 9, 0x0000, 0x10, 18, 3),
	PIN_FIELD_BASE(58, 58, 9, 0x0000, 0x10, 9, 3),
	PIN_FIELD_BASE(59, 59, 9, 0x0000, 0x10, 12, 3),
	PIN_FIELD_BASE(60, 60, 9, 0x0010, 0x10, 24, 3),
	PIN_FIELD_BASE(61, 61, 9, 0x0010, 0x10, 0, 3),
	PIN_FIELD_BASE(62, 62, 9, 0x0000, 0x10, 27, 3),
	PIN_FIELD_BASE(63, 63, 9, 0x0010, 0x10, 12, 3),
	PIN_FIELD_BASE(64, 64, 9, 0x0000, 0x10, 0, 3),
	PIN_FIELD_BASE(65, 65, 9, 0x0010, 0x10, 3, 3),
	PIN_FIELD_BASE(66, 66, 9, 0x0010, 0x10, 27, 3),
	PIN_FIELD_BASE(67, 67, 9, 0x0010, 0x10, 21, 3),
	PIN_FIELD_BASE(68, 68, 9, 0x0010, 0x10, 21, 3),
	PIN_FIELD_BASE(69, 69, 9, 0x0010, 0x10, 21, 3),
	PIN_FIELD_BASE(70, 70, 9, 0x0010, 0x10, 18, 3),
	PIN_FIELD_BASE(71, 71, 9, 0x0010, 0x10, 18, 3),
	PIN_FIELD_BASE(72, 72, 9, 0x0010, 0x10, 21, 3),
	PIN_FIELD_BASE(73, 73, 9, 0x0010, 0x10, 18, 3),
	PIN_FIELD_BASE(74, 74, 9, 0x0010, 0x10, 18, 3),
	PIN_FIELD_BASE(75, 75, 10, 0x0000, 0x10, 6, 3),
	PIN_FIELD_BASE(76, 76, 10, 0x0000, 0x10, 9, 3),
	PIN_FIELD_BASE(77, 77, 10, 0x0000, 0x10, 12, 3),
	PIN_FIELD_BASE(78, 78, 10, 0x0000, 0x10, 15, 3),
	PIN_FIELD_BASE(79, 79, 10, 0x0000, 0x10, 0, 3),
	PIN_FIELD_BASE(80, 80, 10, 0x0000, 0x10, 3, 3),
	PIN_FIELD_BASE(81, 81, 11, 0x0000, 0x10, 18, 3),
	PIN_FIELD_BASE(82, 82, 11, 0x0000, 0x10, 21, 3),
	PIN_FIELD_BASE(83, 83, 11, 0x0000, 0x10, 27, 3),
	PIN_FIELD_BASE(84, 84, 11, 0x0000, 0x10, 24, 3),
	PIN_FIELD_BASE(85, 85, 11, 0x0010, 0x10, 0, 3),
	PIN_FIELD_BASE(86, 86, 11, 0x0010, 0x10, 3, 3),
	PIN_FIELD_BASE(87, 87, 11, 0x0010, 0x10, 9, 3),
	PIN_FIELD_BASE(88, 88, 11, 0x0010, 0x10, 6, 3),
	PIN_FIELD_BASE(89, 89, 11, 0x0000, 0x10, 12, 3),
	PIN_FIELD_BASE(90, 90, 11, 0x0000, 0x10, 12, 3),
	PIN_FIELD_BASE(91, 91, 12, 0x0000, 0x10, 15, 3),
	PIN_FIELD_BASE(92, 92, 12, 0x0000, 0x10, 15, 3),
	PIN_FIELD_BASE(93, 93, 12, 0x0000, 0x10, 15, 3),
	PIN_FIELD_BASE(94, 94, 12, 0x0000, 0x10, 12, 3),
	PIN_FIELD_BASE(95, 95, 12, 0x0000, 0x10, 0, 3),
	PIN_FIELD_BASE(96, 96, 12, 0x0000, 0x10, 6, 3),
	PIN_FIELD_BASE(97, 97, 12, 0x0000, 0x10, 3, 3),
	PIN_FIELD_BASE(98, 98, 12, 0x0000, 0x10, 9, 3),
	PIN_FIELD_BASE(99, 99, 12, 0x0000, 0x10, 18, 3),
	PIN_FIELD_BASE(100, 100, 12, 0x0000, 0x10, 27, 3),
	PIN_FIELD_BASE(101, 101, 12, 0x0000, 0x10, 21, 3),
	PIN_FIELD_BASE(102, 102, 12, 0x0010, 0x10, 0, 3),
	PIN_FIELD_BASE(103, 103, 12, 0x0000, 0x10, 12, 3),
	PIN_FIELD_BASE(104, 104, 12, 0x0000, 0x10, 24, 3),
	PIN_FIELD_BASE(105, 105, 12, 0x0010, 0x10, 3, 3),
	PIN_FIELD_BASE(106, 106, 5, 0x0000, 0x10, 0, 3),
	PIN_FIELD_BASE(107, 107, 5, 0x0000, 0x10, 3, 3),
	PIN_FIELD_BASE(108, 108, 5, 0x0000, 0x10, 9, 3),
	PIN_FIELD_BASE(109, 109, 5, 0x0000, 0x10, 6, 3),
	PIN_FIELD_BASE(110, 110, 5, 0x0000, 0x10, 12, 3),
	PIN_FIELD_BASE(111, 111, 5, 0x0000, 0x10, 15, 3),
	PIN_FIELD_BASE(112, 112, 5, 0x0000, 0x10, 21, 3),
	PIN_FIELD_BASE(113, 113, 5, 0x0000, 0x10, 18, 3),
	PIN_FIELD_BASE(114, 114, 5, 0x0000, 0x10, 24, 3),
	PIN_FIELD_BASE(115, 115, 5, 0x0000, 0x10, 27, 3),
	PIN_FIELD_BASE(116, 116, 5, 0x0010, 0x10, 3, 3),
	PIN_FIELD_BASE(117, 117, 5, 0x0010, 0x10, 0, 3),
	PIN_FIELD_BASE(118, 118, 6, 0x0000, 0x10, 18, 3),
	PIN_FIELD_BASE(119, 119, 6, 0x0000, 0x10, 21, 3),
	PIN_FIELD_BASE(120, 120, 6, 0x0000, 0x10, 27, 3),
	PIN_FIELD_BASE(121, 121, 6, 0x0000, 0x10, 24, 3),
	PIN_FIELD_BASE(122, 122, 6, 0x0000, 0x10, 9, 3),
	PIN_FIELD_BASE(123, 123, 6, 0x0000, 0x10, 12, 3),
	PIN_FIELD_BASE(124, 124, 6, 0x0000, 0x10, 15, 3),
	PIN_FIELD_BASE(125, 125, 7, 0x0000, 0x10, 0, 3),
	PIN_FIELD_BASE(126, 126, 7, 0x0000, 0x10, 3, 3),
	PIN_FIELD_BASE(127, 127, 7, 0x0000, 0x10, 6, 3),
	PIN_FIELD_BASE(128, 128, 7, 0x0000, 0x10, 9, 3),
	PIN_FIELD_BASE(129, 129, 7, 0x0000, 0x10, 12, 3),
	PIN_FIELD_BASE(130, 130, 7, 0x0000, 0x10, 15, 3),
	PIN_FIELD_BASE(131, 131, 7, 0x0000, 0x10, 27, 3),
	PIN_FIELD_BASE(132, 132, 7, 0x0010, 0x10, 3, 3),
	PIN_FIELD_BASE(133, 133, 7, 0x0010, 0x10, 0, 3),
	PIN_FIELD_BASE(134, 134, 7, 0x0000, 0x10, 18, 3),
	PIN_FIELD_BASE(135, 135, 7, 0x0000, 0x10, 24, 3),
	PIN_FIELD_BASE(136, 136, 7, 0x0000, 0x10, 21, 3),
	PIN_FIELD_BASE(137, 137, 4, 0x0000, 0x10, 6, 3),
	PIN_FIELD_BASE(138, 138, 4, 0x0000, 0x10, 9, 3),
	PIN_FIELD_BASE(139, 139, 4, 0x0000, 0x10, 12, 3),
	PIN_FIELD_BASE(140, 140, 4, 0x0000, 0x10, 15, 3),
	PIN_FIELD_BASE(141, 141, 4, 0x0000, 0x10, 18, 3),
	PIN_FIELD_BASE(142, 142, 4, 0x0000, 0x10, 21, 3),
	PIN_FIELD_BASE(143, 143, 4, 0x0000, 0x10, 24, 3),
	PIN_FIELD_BASE(144, 144, 4, 0x0000, 0x10, 27, 3),
	PIN_FIELD_BASE(145, 145, 4, 0x0010, 0x10, 0, 3),
	PIN_FIELD_BASE(146, 146, 4, 0x0010, 0x10, 0, 3),
	PIN_FIELD_BASE(147, 147, 4, 0x0000, 0x10, 0, 3),
	PIN_FIELD_BASE(148, 148, 4, 0x0000, 0x10, 3, 3),
	PIN_FIELD_BASE(149, 149, 4, 0x0010, 0x10, 3, 3),
	PIN_FIELD_BASE(150, 150, 4, 0x0010, 0x10, 3, 3),
	PIN_FIELD_BASE(151, 151, 4, 0x0010, 0x10, 3, 3),
	PIN_FIELD_BASE(152, 152, 4, 0x0010, 0x10, 3, 3),
	PIN_FIELD_BASE(153, 153, 4, 0x0010, 0x10, 12, 3),
	PIN_FIELD_BASE(154, 154, 4, 0x0010, 0x10, 9, 3),
	PIN_FIELD_BASE(155, 155, 4, 0x0010, 0x10, 6, 3),
	PIN_FIELD_BASE(156, 156, 4, 0x0010, 0x10, 6, 3),
	PIN_FIELD_BASE(157, 157, 2, 0x0010, 0x10, 0, 3),
	PIN_FIELD_BASE(158, 158, 2, 0x0010, 0x10, 0, 3),
	PIN_FIELD_BASE(159, 159, 2, 0x0010, 0x10, 0, 3),
	PIN_FIELD_BASE(160, 160, 3, 0x0000, 0x10, 3, 3),
	PIN_FIELD_BASE(161, 161, 3, 0x0000, 0x10, 6, 3),
	PIN_FIELD_BASE(162, 162, 3, 0x0000, 0x10, 6, 3),
	PIN_FIELD_BASE(163, 163, 3, 0x0000, 0x10, 6, 3),
	PIN_FIELD_BASE(164, 164, 3, 0x0000, 0x10, 18, 3),
	PIN_FIELD_BASE(165, 165, 3, 0x0000, 0x10, 24, 3),
	PIN_FIELD_BASE(166, 166, 3, 0x0000, 0x10, 21, 3),
	PIN_FIELD_BASE(167, 167, 3, 0x0000, 0x10, 27, 3),
	PIN_FIELD_BASE(168, 168, 3, 0x0010, 0x10, 0, 3),
	PIN_FIELD_BASE(169, 169, 3, 0x0010, 0x10, 3, 3),
	PIN_FIELD_BASE(170, 170, 3, 0x0010, 0x10, 9, 3),
	PIN_FIELD_BASE(171, 171, 3, 0x0010, 0x10, 6, 3),
	PIN_FIELD_BASE(172, 172, 3, 0x0000, 0x10, 9, 3),
	PIN_FIELD_BASE(173, 173, 3, 0x0000, 0x10, 9, 3),
	PIN_FIELD_BASE(174, 174, 1, 0x0000, 0x10, 27, 3),
	PIN_FIELD_BASE(175, 175, 1, 0x0000, 0x10, 27, 3),
	PIN_FIELD_BASE(176, 176, 1, 0x0010, 0x10, 0, 3),
	PIN_FIELD_BASE(177, 177, 1, 0x0010, 0x10, 3, 3),
	PIN_FIELD_BASE(178, 178, 1, 0x0000, 0x10, 24, 3),
	PIN_FIELD_BASE(179, 179, 1, 0x0000, 0x10, 24, 3),
	PIN_FIELD_BASE(180, 180, 1, 0x0000, 0x10, 0, 3),
	PIN_FIELD_BASE(181, 181, 1, 0x0000, 0x10, 3, 3),
	PIN_FIELD_BASE(182, 182, 1, 0x0000, 0x10, 6, 3),
	PIN_FIELD_BASE(183, 183, 1, 0x0000, 0x10, 9, 3),
	PIN_FIELD_BASE(184, 184, 1, 0x0000, 0x10, 12, 3),
	PIN_FIELD_BASE(185, 185, 1, 0x0000, 0x10, 15, 3),
	PIN_FIELD_BASE(186, 186, 13, 0x0010, 0x10, 12, 3),
	PIN_FIELD_BASE(187, 187, 13, 0x0010, 0x10, 12, 3),
	PIN_FIELD_BASE(188, 188, 13, 0x0000, 0x10, 12, 3),
	PIN_FIELD_BASE(189, 189, 13, 0x0000, 0x10, 27, 3),
	PIN_FIELD_BASE(190, 190, 13, 0x0000, 0x10, 15, 3),
	PIN_FIELD_BASE(191, 191, 13, 0x0010, 0x10, 0, 3),
	PIN_FIELD_BASE(192, 192, 13, 0x0000, 0x10, 0, 3),
	PIN_FIELD_BASE(193, 193, 13, 0x0010, 0x10, 15, 3),
	PIN_FIELD_BASE(194, 194, 13, 0x0000, 0x10, 18, 3),
	PIN_FIELD_BASE(195, 195, 13, 0x0010, 0x10, 3, 3),
	PIN_FIELD_BASE(196, 196, 13, 0x0000, 0x10, 3, 3),
	PIN_FIELD_BASE(197, 197, 13, 0x0010, 0x10, 18, 3),
	PIN_FIELD_BASE(198, 198, 13, 0x0000, 0x10, 21, 3),
	PIN_FIELD_BASE(199, 199, 13, 0x0010, 0x10, 6, 3),
	PIN_FIELD_BASE(200, 200, 13, 0x0010, 0x10, 27, 3),
	PIN_FIELD_BASE(201, 201, 13, 0x0020, 0x10, 6, 3),
	PIN_FIELD_BASE(202, 202, 13, 0x0000, 0x10, 24, 3),
	PIN_FIELD_BASE(203, 203, 13, 0x0010, 0x10, 9, 3),
	PIN_FIELD_BASE(204, 204, 13, 0x0000, 0x10, 6, 3),
	PIN_FIELD_BASE(205, 205, 13, 0x0000, 0x10, 9, 3),
	PIN_FIELD_BASE(206, 206, 13, 0x0010, 0x10, 24, 3),
	PIN_FIELD_BASE(207, 207, 13, 0x0010, 0x10, 21, 3),
	PIN_FIELD_BASE(208, 208, 13, 0x0010, 0x10, 21, 3),
	PIN_FIELD_BASE(209, 209, 13, 0x0010, 0x10, 21, 3),
	PIN_FIELD_BASE(210, 210, 14, 0x0000, 0x10, 0, 3),
	PIN_FIELD_BASE(211, 211, 14, 0x0000, 0x10, 3, 3),
	PIN_FIELD_BASE(212, 212, 14, 0x0000, 0x10, 6, 3),
	PIN_FIELD_BASE(213, 213, 14, 0x0000, 0x10, 9, 3),
	PIN_FIELD_BASE(214, 214, 13, 0x0020, 0x10, 0, 3),
	PIN_FIELD_BASE(215, 215, 13, 0x0020, 0x10, 3, 3),
	PIN_FIELD_BASE(216, 216, 14, 0x0010, 0x10, 6, 3),
	PIN_FIELD_BASE(217, 217, 14, 0x0010, 0x10, 6, 3),
	PIN_FIELD_BASE(218, 218, 14, 0x0000, 0x10, 15, 3),
	PIN_FIELD_BASE(219, 219, 14, 0x0000, 0x10, 12, 3),
	PIN_FIELD_BASE(220, 220, 14, 0x0020, 0x10, 3, 3),
	PIN_FIELD_BASE(221, 221, 14, 0x0020, 0x10, 6, 3),
	PIN_FIELD_BASE(222, 222, 14, 0x0020, 0x10, 12, 3),
	PIN_FIELD_BASE(223, 223, 14, 0x0020, 0x10, 9, 3),
	PIN_FIELD_BASE(224, 224, 14, 0x0000, 0x10, 18, 3),
	PIN_FIELD_BASE(225, 225, 14, 0x0000, 0x10, 21, 3),
	PIN_FIELD_BASE(226, 226, 14, 0x0000, 0x10, 24, 3),
	PIN_FIELD_BASE(227, 227, 14, 0x0000, 0x10, 27, 3),
	PIN_FIELD_BASE(228, 228, 14, 0x0010, 0x10, 0, 3),
	PIN_FIELD_BASE(229, 229, 14, 0x0010, 0x10, 3, 3),
	PIN_FIELD_BASE(230, 230, 15, 0x0000, 0x10, 0, 3),
	PIN_FIELD_BASE(231, 231, 15, 0x0000, 0x10, 0, 3),
	PIN_FIELD_BASE(232, 232, 15, 0x0000, 0x10, 0, 3),
	PIN_FIELD_BASE(233, 233, 15, 0x0000, 0x10, 3, 3),
	PIN_FIELD_BASE(234, 234, 15, 0x0000, 0x10, 3, 3),
	PIN_FIELD_BASE(235, 235, 15, 0x0000, 0x10, 3, 3),
	PIN_FIELD_BASE(236, 236, 15, 0x0000, 0x10, 3, 3),
	PIN_FIELD_BASE(237, 237, 15, 0x0000, 0x10, 6, 3),
	PIN_FIELD_BASE(238, 238, 15, 0x0000, 0x10, 6, 3),
	PIN_FIELD_BASE(239, 239, 15, 0x0000, 0x10, 6, 3),
	PIN_FIELD_BASE(240, 240, 15, 0x0000, 0x10, 6, 3),
	PIN_FIELD_BASE(241, 241, 15, 0x0000, 0x10, 9, 3),
	PIN_FIELD_BASE(242, 242, 15, 0x0000, 0x10, 9, 3),
	PIN_FIELD_BASE(243, 243, 15, 0x0000, 0x10, 9, 3),
	PIN_FIELD_BASE(244, 244, 15, 0x0000, 0x10, 9, 3),
	PIN_FIELD_BASE(245, 245, 15, 0x0000, 0x10, 12, 3),
	PIN_FIELD_BASE(246, 246, 15, 0x0000, 0x10, 15, 3),
	PIN_FIELD_BASE(247, 247, 15, 0x0000, 0x10, 15, 3),
	PIN_FIELD_BASE(248, 248, 15, 0x0000, 0x10, 12, 3),
	PIN_FIELD_BASE(249, 249, 15, 0x0000, 0x10, 12, 3),
	PIN_FIELD_BASE(250, 250, 15, 0x0000, 0x10, 12, 3),
	PIN_FIELD_BASE(251, 251, 3, 0x0000, 0x10, 9, 3),
	PIN_FIELD_BASE(252, 252, 3, 0x0000, 0x10, 12, 3),
	PIN_FIELD_BASE(253, 253, 3, 0x0000, 0x10, 12, 3),
	PIN_FIELD_BASE(254, 254, 3, 0x0000, 0x10, 12, 3),
	PIN_FIELD_BASE(255, 255, 3, 0x0000, 0x10, 12, 3),
	PIN_FIELD_BASE(256, 256, 3, 0x0000, 0x10, 15, 3),
	PIN_FIELD_BASE(257, 257, 3, 0x0000, 0x10, 15, 3),
	PIN_FIELD_BASE(258, 258, 3, 0x0000, 0x10, 15, 3),
	PIN_FIELD_BASE(259, 259, 14, 0x0010, 0x10, 9, 3),
	PIN_FIELD_BASE(260, 260, 14, 0x0010, 0x10, 12, 3),
	PIN_FIELD_BASE(261, 261, 14, 0x0010, 0x10, 15, 3),
	PIN_FIELD_BASE(262, 262, 14, 0x0010, 0x10, 18, 3),
	PIN_FIELD_BASE(263, 263, 14, 0x0010, 0x10, 21, 3),
	PIN_FIELD_BASE(264, 264, 14, 0x0010, 0x10, 24, 3),
	PIN_FIELD_BASE(265, 265, 14, 0x0010, 0x10, 27, 3),
	PIN_FIELD_BASE(266, 266, 14, 0x0020, 0x10, 0, 3),
	PIN_FIELD_BASE(267, 267, 15, 0x0000, 0x10, 24, 3),
	PIN_FIELD_BASE(268, 268, 15, 0x0000, 0x10, 27, 3),
	PIN_FIELD_BASE(269, 269, 15, 0x0000, 0x10, 18, 3),
	PIN_FIELD_BASE(270, 270, 15, 0x0000, 0x10, 21, 3),
};

static const struct mtk_pin_field_calc mt8196_pin_drv_adv_range[] = {
	PIN_FIELD_BASE(46, 46, 8, 0x0030, 0x10, 0, 3),
	PIN_FIELD_BASE(47, 47, 8, 0x0030, 0x10, 9, 3),
	PIN_FIELD_BASE(48, 48, 8, 0x0030, 0x10, 3, 3),
	PIN_FIELD_BASE(49, 49, 8, 0x0030, 0x10, 12, 3),
	PIN_FIELD_BASE(50, 50, 8, 0x0030, 0x10, 6, 3),
	PIN_FIELD_BASE(51, 51, 8, 0x0030, 0x10, 15, 3),
	PIN_FIELD_BASE(52, 52, 9, 0x0030, 0x10, 0, 3),
	PIN_FIELD_BASE(53, 53, 9, 0x0030, 0x10, 3, 3),
	PIN_FIELD_BASE(75, 75, 10, 0x0020, 0x10, 0, 5),
	PIN_FIELD_BASE(76, 76, 10, 0x0020, 0x10, 5, 5),
	PIN_FIELD_BASE(77, 77, 10, 0x0020, 0x10, 10, 5),
	PIN_FIELD_BASE(78, 78, 10, 0x0020, 0x10, 15, 5),
	PIN_FIELD_BASE(99, 99, 12, 0x0020, 0x10, 0, 3),
	PIN_FIELD_BASE(100, 100, 12, 0x0020, 0x10, 9, 3),
	PIN_FIELD_BASE(101, 101, 12, 0x0020, 0x10, 3, 3),
	PIN_FIELD_BASE(102, 102, 12, 0x0020, 0x10, 12, 3),
	PIN_FIELD_BASE(104, 104, 12, 0x0020, 0x10, 6, 3),
	PIN_FIELD_BASE(105, 105, 12, 0x0020, 0x10, 15, 3),
	PIN_FIELD_BASE(123, 123, 6, 0x0020, 0x10, 0, 3),
	PIN_FIELD_BASE(124, 124, 6, 0x0020, 0x10, 3, 3),
	PIN_FIELD_BASE(164, 164, 3, 0x0020, 0x10, 0, 3),
	PIN_FIELD_BASE(165, 165, 3, 0x0020, 0x10, 6, 3),
	PIN_FIELD_BASE(166, 166, 3, 0x0020, 0x10, 3, 3),
	PIN_FIELD_BASE(167, 167, 3, 0x0020, 0x10, 9, 3),
	PIN_FIELD_BASE(168, 168, 3, 0x0020, 0x10, 12, 3),
	PIN_FIELD_BASE(170, 170, 3, 0x0020, 0x10, 15, 3),
	PIN_FIELD_BASE(176, 176, 1, 0x0020, 0x10, 0, 3),
	PIN_FIELD_BASE(177, 177, 1, 0x0020, 0x10, 3, 3),
	PIN_FIELD_BASE(188, 188, 13, 0x0040, 0x10, 0, 3),
	PIN_FIELD_BASE(189, 189, 13, 0x0040, 0x10, 15, 3),
	PIN_FIELD_BASE(190, 190, 13, 0x0040, 0x10, 3, 3),
	PIN_FIELD_BASE(191, 191, 13, 0x0040, 0x10, 18, 3),
	PIN_FIELD_BASE(194, 194, 13, 0x0040, 0x10, 6, 3),
	PIN_FIELD_BASE(195, 195, 13, 0x0040, 0x10, 21, 3),
	PIN_FIELD_BASE(198, 198, 13, 0x0040, 0x10, 9, 3),
	PIN_FIELD_BASE(199, 199, 13, 0x0040, 0x10, 24, 3),
	PIN_FIELD_BASE(200, 200, 13, 0x0050, 0x10, 0, 3),
	PIN_FIELD_BASE(201, 201, 13, 0x0050, 0x10, 9, 3),
	PIN_FIELD_BASE(202, 202, 13, 0x0040, 0x10, 12, 3),
	PIN_FIELD_BASE(203, 203, 13, 0x0040, 0x10, 27, 3),
	PIN_FIELD_BASE(214, 214, 13, 0x0050, 0x10, 3, 3),
	PIN_FIELD_BASE(215, 215, 13, 0x0050, 0x10, 6, 3),
};

static const struct mtk_pin_field_calc mt8196_pin_rsel_range[] = {
	PIN_FIELD_BASE(46, 46, 8, 0x00c0, 0x10, 0, 3),
	PIN_FIELD_BASE(47, 47, 8, 0x00c0, 0x10, 9, 3),
	PIN_FIELD_BASE(48, 48, 8, 0x00c0, 0x10, 3, 3),
	PIN_FIELD_BASE(49, 49, 8, 0x00c0, 0x10, 12, 3),
	PIN_FIELD_BASE(50, 50, 8, 0x00c0, 0x10, 6, 3),
	PIN_FIELD_BASE(51, 51, 8, 0x00c0, 0x10, 15, 3),
	PIN_FIELD_BASE(52, 52, 9, 0x0110, 0x10, 0, 3),
	PIN_FIELD_BASE(53, 53, 9, 0x0110, 0x10, 3, 3),
	PIN_FIELD_BASE(99, 99, 12, 0x00b0, 0x10, 0, 3),
	PIN_FIELD_BASE(100, 100, 12, 0x00b0, 0x10, 9, 3),
	PIN_FIELD_BASE(101, 101, 12, 0x00b0, 0x10, 3, 3),
	PIN_FIELD_BASE(102, 102, 12, 0x00b0, 0x10, 12, 3),
	PIN_FIELD_BASE(104, 104, 12, 0x00b0, 0x10, 6, 3),
	PIN_FIELD_BASE(105, 105, 12, 0x00b0, 0x10, 15, 3),
	PIN_FIELD_BASE(123, 123, 6, 0x0100, 0x10, 0, 3),
	PIN_FIELD_BASE(124, 124, 6, 0x0100, 0x10, 3, 3),
	PIN_FIELD_BASE(164, 164, 3, 0x00b0, 0x10, 0, 3),
	PIN_FIELD_BASE(165, 165, 3, 0x00b0, 0x10, 6, 3),
	PIN_FIELD_BASE(166, 166, 3, 0x00b0, 0x10, 3, 3),
	PIN_FIELD_BASE(167, 167, 3, 0x00b0, 0x10, 9, 3),
	PIN_FIELD_BASE(168, 168, 3, 0x00b0, 0x10, 12, 3),
	PIN_FIELD_BASE(170, 170, 3, 0x00b0, 0x10, 15, 3),
	PIN_FIELD_BASE(176, 176, 1, 0x00b0, 0x10, 0, 3),
	PIN_FIELD_BASE(177, 177, 1, 0x00b0, 0x10, 3, 3),
	PIN_FIELD_BASE(188, 188, 13, 0x00f0, 0x10, 0, 3),
	PIN_FIELD_BASE(189, 189, 13, 0x00f0, 0x10, 15, 3),
	PIN_FIELD_BASE(190, 190, 13, 0x00f0, 0x10, 3, 3),
	PIN_FIELD_BASE(191, 191, 13, 0x00f0, 0x10, 18, 3),
	PIN_FIELD_BASE(194, 194, 13, 0x00f0, 0x10, 6, 3),
	PIN_FIELD_BASE(195, 195, 13, 0x00f0, 0x10, 21, 3),
	PIN_FIELD_BASE(198, 198, 13, 0x00f0, 0x10, 9, 3),
	PIN_FIELD_BASE(199, 199, 13, 0x00f0, 0x10, 24, 3),
	PIN_FIELD_BASE(200, 200, 13, 0x0100, 0x10, 0, 3),
	PIN_FIELD_BASE(201, 201, 13, 0x0100, 0x10, 9, 3),
	PIN_FIELD_BASE(202, 202, 13, 0x00f0, 0x10, 12, 3),
	PIN_FIELD_BASE(203, 203, 13, 0x00f0, 0x10, 27, 3),
	PIN_FIELD_BASE(214, 214, 13, 0x0100, 0x10, 3, 3),
	PIN_FIELD_BASE(215, 215, 13, 0x0100, 0x10, 6, 3),
};

static const struct mtk_pin_rsel mt8196_pin_rsel_val_range[] = {
	PIN_RSEL(46, 53, 0x0, 75000, 75000),
	PIN_RSEL(46, 53, 0x1, 10000, 5000),
	PIN_RSEL(46, 53, 0x2, 5000, 75000),
	PIN_RSEL(46, 53, 0x3, 4000, 5000),
	PIN_RSEL(46, 53, 0x4, 3000, 75000),
	PIN_RSEL(46, 53, 0x5, 2000, 5000),
	PIN_RSEL(46, 53, 0x6, 1500, 75000),
	PIN_RSEL(46, 53, 0x7, 1000, 5000),
	PIN_RSEL(99, 102, 0x0, 75000, 75000),
	PIN_RSEL(99, 102, 0x1, 10000, 5000),
	PIN_RSEL(99, 102, 0x2, 5000, 75000),
	PIN_RSEL(99, 102, 0x3, 4000, 5000),
	PIN_RSEL(99, 102, 0x4, 3000, 75000),
	PIN_RSEL(99, 102, 0x5, 2000, 5000),
	PIN_RSEL(99, 102, 0x6, 1500, 75000),
	PIN_RSEL(99, 102, 0x7, 1000, 5000),
	PIN_RSEL(104, 105, 0x0, 75000, 75000),
	PIN_RSEL(104, 105, 0x1, 10000, 5000),
	PIN_RSEL(104, 105, 0x2, 5000, 75000),
	PIN_RSEL(104, 105, 0x3, 4000, 5000),
	PIN_RSEL(104, 105, 0x4, 3000, 75000),
	PIN_RSEL(104, 105, 0x5, 2000, 5000),
	PIN_RSEL(104, 105, 0x6, 1500, 75000),
	PIN_RSEL(104, 105, 0x7, 1000, 5000),
	PIN_RSEL(123, 124, 0x0, 75000, 75000),
	PIN_RSEL(123, 124, 0x1, 10000, 5000),
	PIN_RSEL(123, 124, 0x2, 5000, 75000),
	PIN_RSEL(123, 124, 0x3, 4000, 5000),
	PIN_RSEL(123, 124, 0x4, 3000, 75000),
	PIN_RSEL(123, 124, 0x5, 2000, 5000),
	PIN_RSEL(123, 124, 0x6, 1500, 75000),
	PIN_RSEL(123, 124, 0x7, 1000, 5000),
	PIN_RSEL(164, 168, 0x0, 75000, 75000),
	PIN_RSEL(164, 168, 0x1, 10000, 5000),
	PIN_RSEL(164, 168, 0x2, 5000, 75000),
	PIN_RSEL(164, 168, 0x3, 4000, 5000),
	PIN_RSEL(164, 168, 0x4, 3000, 75000),
	PIN_RSEL(164, 168, 0x5, 2000, 5000),
	PIN_RSEL(164, 168, 0x6, 1500, 75000),
	PIN_RSEL(164, 168, 0x7, 1000, 5000),
	PIN_RSEL(170, 170, 0x0, 75000, 75000),
	PIN_RSEL(170, 170, 0x1, 10000, 5000),
	PIN_RSEL(170, 170, 0x2, 5000, 75000),
	PIN_RSEL(170, 170, 0x3, 4000, 5000),
	PIN_RSEL(170, 170, 0x4, 3000, 75000),
	PIN_RSEL(170, 170, 0x5, 2000, 5000),
	PIN_RSEL(170, 170, 0x6, 1500, 75000),
	PIN_RSEL(170, 170, 0x7, 1000, 5000),
	PIN_RSEL(176, 177, 0x0, 75000, 75000),
	PIN_RSEL(176, 177, 0x1, 10000, 5000),
	PIN_RSEL(176, 177, 0x2, 5000, 75000),
	PIN_RSEL(176, 177, 0x3, 4000, 5000),
	PIN_RSEL(176, 177, 0x4, 3000, 75000),
	PIN_RSEL(176, 177, 0x5, 2000, 5000),
	PIN_RSEL(176, 177, 0x6, 1500, 75000),
	PIN_RSEL(176, 177, 0x7, 1000, 5000),
	PIN_RSEL(188, 191, 0x0, 75000, 75000),
	PIN_RSEL(188, 191, 0x1, 10000, 5000),
	PIN_RSEL(188, 191, 0x2, 5000, 75000),
	PIN_RSEL(188, 191, 0x3, 4000, 5000),
	PIN_RSEL(188, 191, 0x4, 3000, 75000),
	PIN_RSEL(188, 191, 0x5, 2000, 5000),
	PIN_RSEL(188, 191, 0x6, 1500, 75000),
	PIN_RSEL(188, 191, 0x7, 1000, 5000),
	PIN_RSEL(194, 195, 0x0, 75000, 75000),
	PIN_RSEL(194, 195, 0x1, 10000, 5000),
	PIN_RSEL(194, 195, 0x2, 5000, 75000),
	PIN_RSEL(194, 195, 0x3, 4000, 5000),
	PIN_RSEL(194, 195, 0x4, 3000, 75000),
	PIN_RSEL(194, 195, 0x5, 2000, 5000),
	PIN_RSEL(194, 195, 0x6, 1500, 75000),
	PIN_RSEL(194, 195, 0x7, 1000, 5000),
	PIN_RSEL(198, 203, 0x0, 75000, 75000),
	PIN_RSEL(198, 203, 0x1, 10000, 5000),
	PIN_RSEL(198, 203, 0x2, 5000, 75000),
	PIN_RSEL(198, 203, 0x3, 4000, 5000),
	PIN_RSEL(198, 203, 0x4, 3000, 75000),
	PIN_RSEL(198, 203, 0x5, 2000, 5000),
	PIN_RSEL(198, 203, 0x6, 1500, 75000),
	PIN_RSEL(198, 203, 0x7, 1000, 5000),
	PIN_RSEL(214, 215, 0x0, 75000, 75000),
	PIN_RSEL(214, 215, 0x1, 10000, 5000),
	PIN_RSEL(214, 215, 0x2, 5000, 75000),
	PIN_RSEL(214, 215, 0x3, 4000, 5000),
	PIN_RSEL(214, 215, 0x4, 3000, 75000),
	PIN_RSEL(214, 215, 0x5, 2000, 5000),
	PIN_RSEL(214, 215, 0x6, 1500, 75000),
	PIN_RSEL(214, 215, 0x7, 1000, 5000),
};

static const unsigned int mt8196_pull_type[] = {
	MTK_PULL_PU_PD_TYPE,/*0*/		MTK_PULL_PU_PD_TYPE,/*1*/
	MTK_PULL_PU_PD_TYPE,/*2*/		MTK_PULL_PU_PD_TYPE,/*3*/
	MTK_PULL_PU_PD_TYPE,/*4*/		MTK_PULL_PU_PD_TYPE,/*5*/
	MTK_PULL_PU_PD_TYPE,/*6*/		MTK_PULL_PU_PD_TYPE,/*7*/
	MTK_PULL_PU_PD_TYPE,/*8*/		MTK_PULL_PU_PD_TYPE,/*9*/
	MTK_PULL_PU_PD_TYPE,/*10*/		MTK_PULL_PU_PD_TYPE,/*11*/
	MTK_PULL_PU_PD_TYPE,/*12*/		MTK_PULL_PU_PD_TYPE,/*13*/
	MTK_PULL_PU_PD_TYPE,/*14*/		MTK_PULL_PU_PD_TYPE,/*15*/
	MTK_PULL_PU_PD_TYPE,/*16*/		MTK_PULL_PU_PD_TYPE,/*17*/
	MTK_PULL_PU_PD_TYPE,/*18*/		MTK_PULL_PU_PD_TYPE,/*19*/
	MTK_PULL_PU_PD_TYPE,/*20*/		MTK_PULL_PU_PD_TYPE,/*21*/
	MTK_PULL_PU_PD_TYPE,/*22*/		MTK_PULL_PU_PD_TYPE,/*23*/
	MTK_PULL_PU_PD_TYPE,/*24*/		MTK_PULL_PU_PD_TYPE,/*25*/
	MTK_PULL_PU_PD_TYPE,/*26*/		MTK_PULL_PU_PD_TYPE,/*27*/
	MTK_PULL_PU_PD_TYPE,/*28*/		MTK_PULL_PU_PD_TYPE,/*29*/
	MTK_PULL_PU_PD_TYPE,/*30*/		MTK_PULL_PU_PD_TYPE,/*31*/
	MTK_PULL_PU_PD_TYPE,/*32*/		MTK_PULL_PU_PD_TYPE,/*33*/
	MTK_PULL_PU_PD_TYPE,/*34*/		MTK_PULL_PU_PD_TYPE,/*35*/
	MTK_PULL_PU_PD_TYPE,/*36*/		MTK_PULL_PU_PD_TYPE,/*37*/
	MTK_PULL_PU_PD_TYPE,/*38*/		MTK_PULL_PU_PD_TYPE,/*39*/
	MTK_PULL_PU_PD_TYPE,/*40*/		MTK_PULL_PU_PD_TYPE,/*41*/
	MTK_PULL_PU_PD_TYPE,/*42*/		MTK_PULL_PU_PD_TYPE,/*43*/
	MTK_PULL_PU_PD_TYPE,/*44*/		MTK_PULL_PU_PD_TYPE,/*45*/
	MTK_PULL_PU_PD_RSEL_TYPE,/*46*/		MTK_PULL_PU_PD_RSEL_TYPE,/*47*/
	MTK_PULL_PU_PD_RSEL_TYPE,/*48*/		MTK_PULL_PU_PD_RSEL_TYPE,/*49*/
	MTK_PULL_PU_PD_RSEL_TYPE,/*50*/		MTK_PULL_PU_PD_RSEL_TYPE,/*51*/
	MTK_PULL_PU_PD_RSEL_TYPE,/*52*/		MTK_PULL_PU_PD_RSEL_TYPE,/*53*/
	MTK_PULL_PU_PD_TYPE,/*54*/		MTK_PULL_PU_PD_TYPE,/*55*/
	MTK_PULL_PU_PD_TYPE,/*56*/		MTK_PULL_PU_PD_TYPE,/*57*/
	MTK_PULL_PU_PD_TYPE,/*58*/		MTK_PULL_PU_PD_TYPE,/*59*/
	MTK_PULL_PUPD_R1R0_TYPE,/*60*/		MTK_PULL_PU_PD_TYPE,/*61*/
	MTK_PULL_PU_PD_TYPE,/*62*/		MTK_PULL_PU_PD_TYPE,/*63*/
	MTK_PULL_PU_PD_TYPE,/*64*/		MTK_PULL_PU_PD_TYPE,/*65*/
	MTK_PULL_PU_PD_TYPE,/*66*/		MTK_PULL_PU_PD_TYPE,/*67*/
	MTK_PULL_PU_PD_TYPE,/*68*/		MTK_PULL_PU_PD_TYPE,/*69*/
	MTK_PULL_PU_PD_TYPE,/*70*/		MTK_PULL_PU_PD_TYPE,/*71*/
	MTK_PULL_PU_PD_TYPE,/*72*/		MTK_PULL_PU_PD_TYPE,/*73*/
	MTK_PULL_PU_PD_TYPE,/*74*/		MTK_PULL_PU_PD_TYPE,/*75*/
	MTK_PULL_PU_PD_TYPE,/*76*/		MTK_PULL_PU_PD_TYPE,/*77*/
	MTK_PULL_PU_PD_TYPE,/*78*/		MTK_PULL_PU_PD_TYPE,/*79*/
	MTK_PULL_PU_PD_TYPE,/*80*/		MTK_PULL_PU_PD_TYPE,/*81*/
	MTK_PULL_PU_PD_TYPE,/*82*/		MTK_PULL_PU_PD_TYPE,/*83*/
	MTK_PULL_PU_PD_TYPE,/*84*/		MTK_PULL_PU_PD_TYPE,/*85*/
	MTK_PULL_PU_PD_TYPE,/*86*/		MTK_PULL_PU_PD_TYPE,/*87*/
	MTK_PULL_PU_PD_TYPE,/*88*/		MTK_PULL_PU_PD_TYPE,/*89*/
	MTK_PULL_PU_PD_TYPE,/*90*/		MTK_PULL_PU_PD_TYPE,/*91*/
	MTK_PULL_PU_PD_TYPE,/*92*/		MTK_PULL_PU_PD_TYPE,/*93*/
	MTK_PULL_PU_PD_TYPE,/*94*/		MTK_PULL_PU_PD_TYPE,/*95*/
	MTK_PULL_PU_PD_TYPE,/*96*/		MTK_PULL_PU_PD_TYPE,/*97*/
	MTK_PULL_PU_PD_TYPE,/*98*/		MTK_PULL_PU_PD_RSEL_TYPE,/*99*/
	MTK_PULL_PU_PD_RSEL_TYPE,/*100*/	MTK_PULL_PU_PD_RSEL_TYPE,/*101*/
	MTK_PULL_PU_PD_RSEL_TYPE,/*102*/	MTK_PULL_PU_PD_TYPE,/*103*/
	MTK_PULL_PU_PD_RSEL_TYPE,/*104*/	MTK_PULL_PU_PD_RSEL_TYPE,/*105*/
	MTK_PULL_PU_PD_TYPE,/*106*/		MTK_PULL_PU_PD_TYPE,/*107*/
	MTK_PULL_PU_PD_TYPE,/*108*/		MTK_PULL_PU_PD_TYPE,/*109*/
	MTK_PULL_PU_PD_TYPE,/*110*/		MTK_PULL_PU_PD_TYPE,/*111*/
	MTK_PULL_PU_PD_TYPE,/*112*/		MTK_PULL_PU_PD_TYPE,/*113*/
	MTK_PULL_PU_PD_TYPE,/*114*/		MTK_PULL_PU_PD_TYPE,/*115*/
	MTK_PULL_PU_PD_TYPE,/*116*/		MTK_PULL_PU_PD_TYPE,/*117*/
	MTK_PULL_PU_PD_TYPE,/*118*/		MTK_PULL_PU_PD_TYPE,/*119*/
	MTK_PULL_PU_PD_TYPE,/*120*/		MTK_PULL_PU_PD_TYPE,/*121*/
	MTK_PULL_PU_PD_TYPE,/*122*/		MTK_PULL_PU_PD_RSEL_TYPE,/*123*/
	MTK_PULL_PU_PD_RSEL_TYPE,/*124*/	MTK_PULL_PUPD_R1R0_TYPE,/*125*/
	MTK_PULL_PUPD_R1R0_TYPE,/*126*/		MTK_PULL_PUPD_R1R0_TYPE,/*127*/
	MTK_PULL_PUPD_R1R0_TYPE,/*128*/		MTK_PULL_PUPD_R1R0_TYPE,/*129*/
	MTK_PULL_PUPD_R1R0_TYPE,/*130*/		MTK_PULL_PUPD_R1R0_TYPE,/*131*/
	MTK_PULL_PUPD_R1R0_TYPE,/*132*/		MTK_PULL_PUPD_R1R0_TYPE,/*133*/
	MTK_PULL_PUPD_R1R0_TYPE,/*134*/		MTK_PULL_PUPD_R1R0_TYPE,/*135*/
	MTK_PULL_PUPD_R1R0_TYPE,/*136*/		MTK_PULL_PUPD_R1R0_TYPE,/*137*/
	MTK_PULL_PUPD_R1R0_TYPE,/*138*/		MTK_PULL_PUPD_R1R0_TYPE,/*139*/
	MTK_PULL_PUPD_R1R0_TYPE,/*140*/		MTK_PULL_PUPD_R1R0_TYPE,/*141*/
	MTK_PULL_PUPD_R1R0_TYPE,/*142*/		MTK_PULL_PUPD_R1R0_TYPE,/*143*/
	MTK_PULL_PUPD_R1R0_TYPE,/*144*/		MTK_PULL_PUPD_R1R0_TYPE,/*145*/
	MTK_PULL_PUPD_R1R0_TYPE,/*146*/		MTK_PULL_PUPD_R1R0_TYPE,/*147*/
	MTK_PULL_PUPD_R1R0_TYPE,/*148*/		MTK_PULL_PUPD_R1R0_TYPE,/*149*/
	MTK_PULL_PUPD_R1R0_TYPE,/*150*/		MTK_PULL_PUPD_R1R0_TYPE,/*151*/
	MTK_PULL_PUPD_R1R0_TYPE,/*152*/		MTK_PULL_PUPD_R1R0_TYPE,/*153*/
	MTK_PULL_PUPD_R1R0_TYPE,/*154*/		MTK_PULL_PUPD_R1R0_TYPE,/*155*/
	MTK_PULL_PUPD_R1R0_TYPE,/*156*/		MTK_PULL_PU_PD_TYPE,/*157*/
	MTK_PULL_PU_PD_TYPE,/*158*/		MTK_PULL_PU_PD_TYPE,/*159*/
	MTK_PULL_PU_PD_TYPE,/*160*/		MTK_PULL_PU_PD_TYPE,/*161*/
	MTK_PULL_PU_PD_TYPE,/*162*/		MTK_PULL_PU_PD_TYPE,/*163*/
	MTK_PULL_PU_PD_RSEL_TYPE,/*164*/	MTK_PULL_PU_PD_RSEL_TYPE,/*165*/
	MTK_PULL_PU_PD_RSEL_TYPE,/*166*/	MTK_PULL_PU_PD_RSEL_TYPE,/*167*/
	MTK_PULL_PU_PD_RSEL_TYPE,/*168*/	MTK_PULL_PU_PD_TYPE,/*169*/
	MTK_PULL_PU_PD_RSEL_TYPE,/*170*/	MTK_PULL_PU_PD_TYPE,/*171*/
	MTK_PULL_PU_PD_TYPE,/*172*/		MTK_PULL_PU_PD_TYPE,/*173*/
	MTK_PULL_PU_PD_TYPE,/*174*/		MTK_PULL_PU_PD_TYPE,/*175*/
	MTK_PULL_PU_PD_RSEL_TYPE,/*176*/	MTK_PULL_PU_PD_RSEL_TYPE,/*177*/
	MTK_PULL_PU_PD_TYPE,/*178*/		MTK_PULL_PU_PD_TYPE,/*179*/
	MTK_PULL_PU_PD_TYPE,/*180*/		MTK_PULL_PU_PD_TYPE,/*181*/
	MTK_PULL_PU_PD_TYPE,/*182*/		MTK_PULL_PU_PD_TYPE,/*183*/
	MTK_PULL_PU_PD_TYPE,/*184*/		MTK_PULL_PU_PD_TYPE,/*185*/
	MTK_PULL_PU_PD_TYPE,/*186*/		MTK_PULL_PU_PD_TYPE,/*187*/
	MTK_PULL_PU_PD_RSEL_TYPE,/*188*/	MTK_PULL_PU_PD_RSEL_TYPE,/*189*/
	MTK_PULL_PU_PD_RSEL_TYPE,/*190*/	MTK_PULL_PU_PD_RSEL_TYPE,/*191*/
	MTK_PULL_PU_PD_TYPE,/*192*/		MTK_PULL_PU_PD_TYPE,/*193*/
	MTK_PULL_PU_PD_RSEL_TYPE,/*194*/	MTK_PULL_PU_PD_RSEL_TYPE,/*195*/
	MTK_PULL_PU_PD_TYPE,/*196*/		MTK_PULL_PU_PD_TYPE,/*197*/
	MTK_PULL_PU_PD_RSEL_TYPE,/*198*/	MTK_PULL_PU_PD_RSEL_TYPE,/*199*/
	MTK_PULL_PU_PD_RSEL_TYPE,/*200*/	MTK_PULL_PU_PD_RSEL_TYPE,/*201*/
	MTK_PULL_PU_PD_RSEL_TYPE,/*202*/	MTK_PULL_PU_PD_RSEL_TYPE,/*203*/
	MTK_PULL_PU_PD_TYPE,/*204*/		MTK_PULL_PU_PD_TYPE,/*205*/
	MTK_PULL_PU_PD_TYPE,/*206*/		MTK_PULL_PU_PD_TYPE,/*207*/
	MTK_PULL_PU_PD_TYPE,/*208*/		MTK_PULL_PU_PD_TYPE,/*209*/
	MTK_PULL_PU_PD_TYPE,/*210*/		MTK_PULL_PU_PD_TYPE,/*211*/
	MTK_PULL_PU_PD_TYPE,/*212*/		MTK_PULL_PU_PD_TYPE,/*213*/
	MTK_PULL_PU_PD_RSEL_TYPE,/*214*/	MTK_PULL_PU_PD_RSEL_TYPE,/*215*/
	MTK_PULL_PU_PD_TYPE,/*216*/		MTK_PULL_PUPD_R1R0_TYPE,/*217*/
	MTK_PULL_PUPD_R1R0_TYPE,/*218*/		MTK_PULL_PUPD_R1R0_TYPE,/*219*/
	MTK_PULL_PU_PD_TYPE,/*220*/		MTK_PULL_PU_PD_TYPE,/*221*/
	MTK_PULL_PU_PD_TYPE,/*222*/		MTK_PULL_PU_PD_TYPE,/*223*/
	MTK_PULL_PUPD_R1R0_TYPE,/*224*/		MTK_PULL_PUPD_R1R0_TYPE,/*225*/
	MTK_PULL_PUPD_R1R0_TYPE,/*226*/		MTK_PULL_PUPD_R1R0_TYPE,/*227*/
	MTK_PULL_PUPD_R1R0_TYPE,/*228*/		MTK_PULL_PUPD_R1R0_TYPE,/*229*/
	MTK_PULL_PU_PD_TYPE,/*230*/		MTK_PULL_PU_PD_TYPE,/*231*/
	MTK_PULL_PU_PD_TYPE,/*232*/		MTK_PULL_PU_PD_TYPE,/*233*/
	MTK_PULL_PU_PD_TYPE,/*234*/		MTK_PULL_PU_PD_TYPE,/*235*/
	MTK_PULL_PU_PD_TYPE,/*236*/		MTK_PULL_PU_PD_TYPE,/*237*/
	MTK_PULL_PU_PD_TYPE,/*238*/		MTK_PULL_PU_PD_TYPE,/*239*/
	MTK_PULL_PU_PD_TYPE,/*240*/		MTK_PULL_PU_PD_TYPE,/*241*/
	MTK_PULL_PU_PD_TYPE,/*242*/		MTK_PULL_PU_PD_TYPE,/*243*/
	MTK_PULL_PU_PD_TYPE,/*244*/		MTK_PULL_PU_PD_TYPE,/*245*/
	MTK_PULL_PU_PD_TYPE,/*246*/		MTK_PULL_PU_PD_TYPE,/*247*/
	MTK_PULL_PU_PD_TYPE,/*248*/		MTK_PULL_PU_PD_TYPE,/*249*/
	MTK_PULL_PU_PD_TYPE,/*250*/		MTK_PULL_PU_PD_TYPE,/*251*/
	MTK_PULL_PU_PD_TYPE,/*252*/		MTK_PULL_PU_PD_TYPE,/*253*/
	MTK_PULL_PU_PD_TYPE,/*254*/		MTK_PULL_PU_PD_TYPE,/*255*/
	MTK_PULL_PU_PD_TYPE,/*256*/		MTK_PULL_PU_PD_TYPE,/*257*/
	MTK_PULL_PU_PD_TYPE,/*258*/		MTK_PULL_PUPD_R1R0_TYPE,/*259*/
	MTK_PULL_PUPD_R1R0_TYPE,/*260*/		MTK_PULL_PUPD_R1R0_TYPE,/*261*/
	MTK_PULL_PUPD_R1R0_TYPE,/*262*/		MTK_PULL_PUPD_R1R0_TYPE,/*263*/
	MTK_PULL_PUPD_R1R0_TYPE,/*264*/		MTK_PULL_PUPD_R1R0_TYPE,/*265*/
	MTK_PULL_PUPD_R1R0_TYPE,/*266*/		MTK_PULL_PUPD_R1R0_TYPE,/*267*/
	MTK_PULL_PUPD_R1R0_TYPE,/*268*/		MTK_PULL_PUPD_R1R0_TYPE,/*269*/
	MTK_PULL_PUPD_R1R0_TYPE,/*270*/
};

static const struct mtk_pin_reg_calc mt8196_reg_cals[PINCTRL_PIN_REG_MAX] = {
	[PINCTRL_PIN_REG_MODE] = MTK_RANGE(mt8196_pin_mode_range),
	[PINCTRL_PIN_REG_DIR] = MTK_RANGE(mt8196_pin_dir_range),
	[PINCTRL_PIN_REG_DI] = MTK_RANGE(mt8196_pin_di_range),
	[PINCTRL_PIN_REG_DO] = MTK_RANGE(mt8196_pin_do_range),
	[PINCTRL_PIN_REG_SMT] = MTK_RANGE(mt8196_pin_smt_range),
	[PINCTRL_PIN_REG_IES] = MTK_RANGE(mt8196_pin_ies_range),
	[PINCTRL_PIN_REG_PUPD] = MTK_RANGE(mt8196_pin_pupd_range),
	[PINCTRL_PIN_REG_R0] = MTK_RANGE(mt8196_pin_r0_range),
	[PINCTRL_PIN_REG_R1] = MTK_RANGE(mt8196_pin_r1_range),
	[PINCTRL_PIN_REG_PU] = MTK_RANGE(mt8196_pin_pu_range),
	[PINCTRL_PIN_REG_PD] = MTK_RANGE(mt8196_pin_pd_range),
	[PINCTRL_PIN_REG_DRV] = MTK_RANGE(mt8196_pin_drv_range),
	[PINCTRL_PIN_REG_DRV_ADV] = MTK_RANGE(mt8196_pin_drv_adv_range),
	[PINCTRL_PIN_REG_RSEL] = MTK_RANGE(mt8196_pin_rsel_range),
};

static const char * const mt8196_pinctrl_register_base_names[] = {
	"iocfg0", "iocfg_rt", "iocfg_rm1", "iocfg_rm2",
	"iocfg_rb", "iocfg_bm1", "iocfg_bm2", "iocfg_bm3",
	"iocfg_lt", "iocfg_lm1", "iocfg_lm2", "iocfg_lb1",
	"iocfg_lb2", "iocfg_tm1", "iocfg_tm2", "iocfg_tm3",
};

static const struct mtk_eint_hw mt8196_eint_hw = {
	.port_mask = 0xf,
	.ports     = 3,
	.ap_num    = 293,
	.db_cnt    = 32,
	.db_time   = debounce_time_mt6765,
};

static const struct mtk_pin_soc mt8196_data = {
	.reg_cal = mt8196_reg_cals,
	.pins = mtk_pins_mt8196,
	.npins = ARRAY_SIZE(mtk_pins_mt8196),
	.ngrps = ARRAY_SIZE(mtk_pins_mt8196),
	.eint_hw = &mt8196_eint_hw,
	.eint_pin = eint_pins_mt8196,
	.nfuncs = 8,
	.gpio_m = 0,
	.base_names = mt8196_pinctrl_register_base_names,
	.nbase_names = ARRAY_SIZE(mt8196_pinctrl_register_base_names),
	.pull_type = mt8196_pull_type,
	.pin_rsel = mt8196_pin_rsel_val_range,
	.npin_rsel = ARRAY_SIZE(mt8196_pin_rsel_val_range),
	.bias_set_combo = mtk_pinconf_bias_set_combo,
	.bias_get_combo = mtk_pinconf_bias_get_combo,
	.drive_set = mtk_pinconf_drive_set_rev1,
	.drive_get = mtk_pinconf_drive_get_rev1,
	.adv_drive_get = mtk_pinconf_adv_drive_get_raw,
	.adv_drive_set = mtk_pinconf_adv_drive_set_raw,
};

static const struct of_device_id mt8196_pinctrl_of_match[] = {
	{ .compatible = "mediatek,mt8196-pinctrl", .data = &mt8196_data },
	{ /* sentinel */ }
};

static struct platform_driver mt8196_pinctrl_driver = {
	.driver = {
		.name = "mt8196-pinctrl",
		.of_match_table = mt8196_pinctrl_of_match,
		.pm = pm_sleep_ptr(&mtk_paris_pinctrl_pm_ops),
	},
	.probe = mtk_paris_pinctrl_probe,
};

static int __init mt8196_pinctrl_init(void)
{
	return platform_driver_register(&mt8196_pinctrl_driver);
}
arch_initcall(mt8196_pinctrl_init);

MODULE_DESCRIPTION("MediaTek MT8196 Pinctrl Driver");
