/* -*- Mode: C++; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef ORG_MPRIS_MEDIAPLAYER2_H
#define ORG_MPRIS_MEDIAPLAYER2_H

#include <QtCore/QObject>
#include <QtCore/QByteArray>
#include <QtCore/QList>
#include <QtCore/QMap>
#include <QtCore/QString>
#include <QtCore/QStringList>
#include <QtCore/QVariant>
#include <QtDBus/QtDBus>

/*
 * Proxy class for interface org.mpris.MediaPlayer2
 */
class OrgMprisMediaPlayer2Interface: public QDBusAbstractInterface
{
    Q_OBJECT
public:
    static inline const char *staticInterfaceName()
    { return "org.mpris.MediaPlayer2"; }

public:
    OrgMprisMediaPlayer2Interface(const QString &service, const QString &path, const QDBusConnection &connection, QObject *parent = nullptr);

    ~OrgMprisMediaPlayer2Interface();

    Q_PROPERTY(bool CanQuit READ canQuit)
    inline bool canQuit() const
    { return qvariant_cast< bool >(property("CanQuit")); }

    Q_PROPERTY(bool CanRaise READ canRaise)
    inline bool canRaise() const
    { return qvariant_cast< bool >(property("CanRaise")); }

    Q_PROPERTY(bool CanSetFullscreen READ canSetFullscreen)
    inline bool canSetFullscreen() const
    { return qvariant_cast< bool >(property("CanSetFullscreen")); }

    Q_PROPERTY(QString DesktopEntry READ desktopEntry)
    inline QString desktopEntry() const
    { return qvariant_cast< QString >(property("DesktopEntry")); }

    Q_PROPERTY(bool Fullscreen READ fullscreen WRITE setFullscreen)
    inline bool fullscreen() const
    { return qvariant_cast< bool >(property("Fullscreen")); }
    inline void setFullscreen(bool value)
    { setProperty("Fullscreen", QVariant::fromValue(value)); }

    Q_PROPERTY(bool HasTrackList READ hasTrackList)
    inline bool hasTrackList() const
    { return qvariant_cast< bool >(property("HasTrackList")); }

    Q_PROPERTY(QString Identity READ identity)
    inline QString identity() const
    { return qvariant_cast< QString >(property("Identity")); }

    Q_PROPERTY(QStringList SupportedMimeTypes READ supportedMimeTypes)
    inline QStringList supportedMimeTypes() const
    { return qvariant_cast< QStringList >(property("SupportedMimeTypes")); }

    Q_PROPERTY(QStringList SupportedUriSchemes READ supportedUriSchemes)
    inline QStringList supportedUriSchemes() const
    { return qvariant_cast< QStringList >(property("SupportedUriSchemes")); }

public Q_SLOTS: // METHODS
    inline QDBusPendingReply<> Quit()
    {
        QList<QVariant> argumentList;
        return asyncCallWithArgumentList(QStringLiteral("Quit"), argumentList);
    }

    inline QDBusPendingReply<> Raise()
    {
        QList<QVariant> argumentList;
        return asyncCallWithArgumentList(QStringLiteral("Raise"), argumentList);
    }

Q_SIGNALS: // SIGNALS
};
#endif
