/* -*- Mode: C++; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "gamma-brightness.h"

GammaBrightness::GammaBrightness(QObject *parent)
{
    USD_LOG(LOG_DEBUG,".");
}

int GammaBrightness::getBrightness()
{
    if (m_pGmDbusInterface == nullptr) {
        return -1;
    }
    QDBusMessage response =  m_pGmDbusInterface->call("getPrimaryBrightness");

    if (response.type() != QDBusMessage::ReplyMessage) {
        return -1;
    }
    int ret = response.arguments().takeFirst().toInt();
    USD_LOG_SHOW_PARAM1(ret);
    return ret;
}

int GammaBrightness::setBrightness(int brightness)
{
    if (m_pGmDbusInterface == nullptr) {
        return -1;
    }

    QDBusMessage response =  m_pGmDbusInterface->call("setPrimaryBrightness", "self.", brightness);

    if (response.type() != QDBusMessage::ReplyMessage) {
        return -1;
    }

    return response.arguments().takeFirst().toInt();
}

int GammaBrightness::connectTheSignal()
{
    m_pGmDbusInterface = new QDBusInterface(DBUS_GM_NAME,DBUS_GM_PATH,DBUS_GM_INTERFACE,
                                                                 QDBusConnection::sessionBus());

    if (!m_pGmDbusInterface->isValid()) {
        m_pGmDbusInterface = nullptr;
        return 0;
    }
    m_pGmDbusInterface->call("enablePrimarySignal", true);
    return 1;
}

QString GammaBrightness::backend()
{
    return "gamma manager";
}
