
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <IFSelect_EditForm.hxx>
#include <Interface_InterfaceModel.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <StepData_StepModel.hxx>
#include <Interface_Protocol.hxx>

// module includes
#include <APIHeaderSection_EditHeader.hxx>
#include <APIHeaderSection_MakeHeader.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
        #include <HeaderSection_FileName.hxx>
        #include <HeaderSection_FileSchema.hxx>
        #include <HeaderSection_FileDescription.hxx>

// Module definiiton
void register_APIHeaderSection_enums(py::module &main_module) {


py::module m = main_module.def_submodule("APIHeaderSection", R"#()#");

// user-defined inclusion per module in the body

// enums

//Python trampoline classes

// pre-register typdefs+classes (topologically sorted)
    py::class_<APIHeaderSection_MakeHeader , shared_ptr<APIHeaderSection_MakeHeader>  >(m,"APIHeaderSection_MakeHeader",R"#(This class allows to consult and prepare/edit data stored in a Step Model Header)#");
    py::class_<APIHeaderSection_EditHeader ,opencascade::handle<APIHeaderSection_EditHeader>  , IFSelect_Editor >(m,"APIHeaderSection_EditHeader",R"#()#");

};

// user-defined post-inclusion per module

// user-defined post
