# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, Optional, TYPE_CHECKING, cast
from typing_extensions import Self

from azure.core.pipeline import policies
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.settings import settings
from azure.mgmt.core import AsyncARMPipelineClient
from azure.mgmt.core.policies import AsyncARMAutoResourceProviderRegistrationPolicy
from azure.mgmt.core.tools import get_arm_endpoints

from .. import models as _models
from .._utils.serialization import Deserializer, Serializer
from ._configuration import SecurityCenterConfiguration
from .operations import (
    APICollectionsOperations,
    AdvancedThreatProtectionOperations,
    AlertsOperations,
    AlertsSuppressionRulesOperations,
    AllowedConnectionsOperations,
    ApplicationOperations,
    ApplicationsOperations,
    AssessmentsMetadataOperations,
    AssessmentsOperations,
    AutoProvisioningSettingsOperations,
    AutomationsOperations,
    AzureDevOpsOrgsOperations,
    AzureDevOpsProjectsOperations,
    AzureDevOpsReposOperations,
    ComplianceResultsOperations,
    CompliancesOperations,
    ConnectorsOperations,
    CustomAssessmentAutomationsOperations,
    CustomEntityStoreAssignmentsOperations,
    CustomRecommendationsOperations,
    DefenderForStorageOperations,
    DevOpsConfigurationsOperations,
    DevOpsOperationResultsOperations,
    DeviceSecurityGroupsOperations,
    DiscoveredSecuritySolutionsOperations,
    ExternalSecuritySolutionsOperations,
    GitHubOwnersOperations,
    GitHubReposOperations,
    GitLabGroupsOperations,
    GitLabProjectsOperations,
    GitLabSubgroupsOperations,
    GovernanceAssignmentsOperations,
    GovernanceRulesOperations,
    HealthReportsOperations,
    InformationProtectionPoliciesOperations,
    IotSecuritySolutionAnalyticsOperations,
    IotSecuritySolutionOperations,
    IotSecuritySolutionsAnalyticsAggregatedAlertOperations,
    IotSecuritySolutionsAnalyticsRecommendationOperations,
    JitNetworkAccessPoliciesOperations,
    LocationsOperations,
    MdeOnboardingsOperations,
    Operations,
    PricingsOperations,
    PrivateEndpointConnectionsOperations,
    PrivateLinkResourcesOperations,
    PrivateLinksOperations,
    RegulatoryComplianceAssessmentsOperations,
    RegulatoryComplianceControlsOperations,
    RegulatoryComplianceStandardsOperations,
    SecureScoreControlDefinitionsOperations,
    SecureScoreControlsOperations,
    SecureScoresOperations,
    SecurityConnectorApplicationOperations,
    SecurityConnectorApplicationsOperations,
    SecurityConnectorsOperations,
    SecurityContactsOperations,
    SecurityOperatorsOperations,
    SecuritySolutionsOperations,
    SecuritySolutionsReferenceDataOperations,
    SecurityStandardsOperations,
    SensitivitySettingsOperations,
    ServerVulnerabilityAssessmentOperations,
    ServerVulnerabilityAssessmentsSettingsOperations,
    SettingsOperations,
    SoftwareInventoriesOperations,
    SqlVulnerabilityAssessmentBaselineRulesOperations,
    SqlVulnerabilityAssessmentScanResultsOperations,
    SqlVulnerabilityAssessmentScansOperations,
    StandardAssignmentsOperations,
    SubAssessmentsOperations,
    TasksOperations,
    TopologyOperations,
    WorkspaceSettingsOperations,
)

if TYPE_CHECKING:
    from azure.core.credentials_async import AsyncTokenCredential


class SecurityCenter:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """API spec for Microsoft.Security (Azure Security Center) resource provider.

    :ivar locations: LocationsOperations operations
    :vartype locations: azure.mgmt.security.aio.operations.LocationsOperations
    :ivar tasks: TasksOperations operations
    :vartype tasks: azure.mgmt.security.aio.operations.TasksOperations
    :ivar auto_provisioning_settings: AutoProvisioningSettingsOperations operations
    :vartype auto_provisioning_settings:
     azure.mgmt.security.aio.operations.AutoProvisioningSettingsOperations
    :ivar compliances: CompliancesOperations operations
    :vartype compliances: azure.mgmt.security.aio.operations.CompliancesOperations
    :ivar information_protection_policies: InformationProtectionPoliciesOperations operations
    :vartype information_protection_policies:
     azure.mgmt.security.aio.operations.InformationProtectionPoliciesOperations
    :ivar workspace_settings: WorkspaceSettingsOperations operations
    :vartype workspace_settings: azure.mgmt.security.aio.operations.WorkspaceSettingsOperations
    :ivar alerts_suppression_rules: AlertsSuppressionRulesOperations operations
    :vartype alerts_suppression_rules:
     azure.mgmt.security.aio.operations.AlertsSuppressionRulesOperations
    :ivar regulatory_compliance_standards: RegulatoryComplianceStandardsOperations operations
    :vartype regulatory_compliance_standards:
     azure.mgmt.security.aio.operations.RegulatoryComplianceStandardsOperations
    :ivar regulatory_compliance_controls: RegulatoryComplianceControlsOperations operations
    :vartype regulatory_compliance_controls:
     azure.mgmt.security.aio.operations.RegulatoryComplianceControlsOperations
    :ivar regulatory_compliance_assessments: RegulatoryComplianceAssessmentsOperations operations
    :vartype regulatory_compliance_assessments:
     azure.mgmt.security.aio.operations.RegulatoryComplianceAssessmentsOperations
    :ivar sub_assessments: SubAssessmentsOperations operations
    :vartype sub_assessments: azure.mgmt.security.aio.operations.SubAssessmentsOperations
    :ivar connectors: ConnectorsOperations operations
    :vartype connectors: azure.mgmt.security.aio.operations.ConnectorsOperations
    :ivar software_inventories: SoftwareInventoriesOperations operations
    :vartype software_inventories: azure.mgmt.security.aio.operations.SoftwareInventoriesOperations
    :ivar custom_assessment_automations: CustomAssessmentAutomationsOperations operations
    :vartype custom_assessment_automations:
     azure.mgmt.security.aio.operations.CustomAssessmentAutomationsOperations
    :ivar custom_entity_store_assignments: CustomEntityStoreAssignmentsOperations operations
    :vartype custom_entity_store_assignments:
     azure.mgmt.security.aio.operations.CustomEntityStoreAssignmentsOperations
    :ivar mde_onboardings: MdeOnboardingsOperations operations
    :vartype mde_onboardings: azure.mgmt.security.aio.operations.MdeOnboardingsOperations
    :ivar governance_assignments: GovernanceAssignmentsOperations operations
    :vartype governance_assignments:
     azure.mgmt.security.aio.operations.GovernanceAssignmentsOperations
    :ivar governance_rules: GovernanceRulesOperations operations
    :vartype governance_rules: azure.mgmt.security.aio.operations.GovernanceRulesOperations
    :ivar applications: ApplicationsOperations operations
    :vartype applications: azure.mgmt.security.aio.operations.ApplicationsOperations
    :ivar application: ApplicationOperations operations
    :vartype application: azure.mgmt.security.aio.operations.ApplicationOperations
    :ivar security_connector_applications: SecurityConnectorApplicationsOperations operations
    :vartype security_connector_applications:
     azure.mgmt.security.aio.operations.SecurityConnectorApplicationsOperations
    :ivar security_connector_application: SecurityConnectorApplicationOperations operations
    :vartype security_connector_application:
     azure.mgmt.security.aio.operations.SecurityConnectorApplicationOperations
    :ivar security_operators: SecurityOperatorsOperations operations
    :vartype security_operators: azure.mgmt.security.aio.operations.SecurityOperatorsOperations
    :ivar sql_vulnerability_assessment_baseline_rules:
     SqlVulnerabilityAssessmentBaselineRulesOperations operations
    :vartype sql_vulnerability_assessment_baseline_rules:
     azure.mgmt.security.aio.operations.SqlVulnerabilityAssessmentBaselineRulesOperations
    :ivar sql_vulnerability_assessment_scans: SqlVulnerabilityAssessmentScansOperations operations
    :vartype sql_vulnerability_assessment_scans:
     azure.mgmt.security.aio.operations.SqlVulnerabilityAssessmentScansOperations
    :ivar sql_vulnerability_assessment_scan_results:
     SqlVulnerabilityAssessmentScanResultsOperations operations
    :vartype sql_vulnerability_assessment_scan_results:
     azure.mgmt.security.aio.operations.SqlVulnerabilityAssessmentScanResultsOperations
    :ivar sensitivity_settings: SensitivitySettingsOperations operations
    :vartype sensitivity_settings: azure.mgmt.security.aio.operations.SensitivitySettingsOperations
    :ivar health_reports: HealthReportsOperations operations
    :vartype health_reports: azure.mgmt.security.aio.operations.HealthReportsOperations
    :ivar automations: AutomationsOperations operations
    :vartype automations: azure.mgmt.security.aio.operations.AutomationsOperations
    :ivar security_contacts: SecurityContactsOperations operations
    :vartype security_contacts: azure.mgmt.security.aio.operations.SecurityContactsOperations
    :ivar security_connectors: SecurityConnectorsOperations operations
    :vartype security_connectors: azure.mgmt.security.aio.operations.SecurityConnectorsOperations
    :ivar defender_for_storage: DefenderForStorageOperations operations
    :vartype defender_for_storage: azure.mgmt.security.aio.operations.DefenderForStorageOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.security.aio.operations.Operations
    :ivar assessments_metadata: AssessmentsMetadataOperations operations
    :vartype assessments_metadata: azure.mgmt.security.aio.operations.AssessmentsMetadataOperations
    :ivar assessments: AssessmentsOperations operations
    :vartype assessments: azure.mgmt.security.aio.operations.AssessmentsOperations
    :ivar private_links: PrivateLinksOperations operations
    :vartype private_links: azure.mgmt.security.aio.operations.PrivateLinksOperations
    :ivar private_link_resources: PrivateLinkResourcesOperations operations
    :vartype private_link_resources:
     azure.mgmt.security.aio.operations.PrivateLinkResourcesOperations
    :ivar private_endpoint_connections: PrivateEndpointConnectionsOperations operations
    :vartype private_endpoint_connections:
     azure.mgmt.security.aio.operations.PrivateEndpointConnectionsOperations
    :ivar compliance_results: ComplianceResultsOperations operations
    :vartype compliance_results: azure.mgmt.security.aio.operations.ComplianceResultsOperations
    :ivar advanced_threat_protection: AdvancedThreatProtectionOperations operations
    :vartype advanced_threat_protection:
     azure.mgmt.security.aio.operations.AdvancedThreatProtectionOperations
    :ivar device_security_groups: DeviceSecurityGroupsOperations operations
    :vartype device_security_groups:
     azure.mgmt.security.aio.operations.DeviceSecurityGroupsOperations
    :ivar iot_security_solution_analytics: IotSecuritySolutionAnalyticsOperations operations
    :vartype iot_security_solution_analytics:
     azure.mgmt.security.aio.operations.IotSecuritySolutionAnalyticsOperations
    :ivar iot_security_solutions_analytics_aggregated_alert:
     IotSecuritySolutionsAnalyticsAggregatedAlertOperations operations
    :vartype iot_security_solutions_analytics_aggregated_alert:
     azure.mgmt.security.aio.operations.IotSecuritySolutionsAnalyticsAggregatedAlertOperations
    :ivar iot_security_solutions_analytics_recommendation:
     IotSecuritySolutionsAnalyticsRecommendationOperations operations
    :vartype iot_security_solutions_analytics_recommendation:
     azure.mgmt.security.aio.operations.IotSecuritySolutionsAnalyticsRecommendationOperations
    :ivar iot_security_solution: IotSecuritySolutionOperations operations
    :vartype iot_security_solution:
     azure.mgmt.security.aio.operations.IotSecuritySolutionOperations
    :ivar allowed_connections: AllowedConnectionsOperations operations
    :vartype allowed_connections: azure.mgmt.security.aio.operations.AllowedConnectionsOperations
    :ivar discovered_security_solutions: DiscoveredSecuritySolutionsOperations operations
    :vartype discovered_security_solutions:
     azure.mgmt.security.aio.operations.DiscoveredSecuritySolutionsOperations
    :ivar external_security_solutions: ExternalSecuritySolutionsOperations operations
    :vartype external_security_solutions:
     azure.mgmt.security.aio.operations.ExternalSecuritySolutionsOperations
    :ivar jit_network_access_policies: JitNetworkAccessPoliciesOperations operations
    :vartype jit_network_access_policies:
     azure.mgmt.security.aio.operations.JitNetworkAccessPoliciesOperations
    :ivar secure_scores: SecureScoresOperations operations
    :vartype secure_scores: azure.mgmt.security.aio.operations.SecureScoresOperations
    :ivar secure_score_controls: SecureScoreControlsOperations operations
    :vartype secure_score_controls:
     azure.mgmt.security.aio.operations.SecureScoreControlsOperations
    :ivar secure_score_control_definitions: SecureScoreControlDefinitionsOperations operations
    :vartype secure_score_control_definitions:
     azure.mgmt.security.aio.operations.SecureScoreControlDefinitionsOperations
    :ivar security_solutions: SecuritySolutionsOperations operations
    :vartype security_solutions: azure.mgmt.security.aio.operations.SecuritySolutionsOperations
    :ivar security_solutions_reference_data: SecuritySolutionsReferenceDataOperations operations
    :vartype security_solutions_reference_data:
     azure.mgmt.security.aio.operations.SecuritySolutionsReferenceDataOperations
    :ivar server_vulnerability_assessment: ServerVulnerabilityAssessmentOperations operations
    :vartype server_vulnerability_assessment:
     azure.mgmt.security.aio.operations.ServerVulnerabilityAssessmentOperations
    :ivar topology: TopologyOperations operations
    :vartype topology: azure.mgmt.security.aio.operations.TopologyOperations
    :ivar alerts: AlertsOperations operations
    :vartype alerts: azure.mgmt.security.aio.operations.AlertsOperations
    :ivar settings: SettingsOperations operations
    :vartype settings: azure.mgmt.security.aio.operations.SettingsOperations
    :ivar server_vulnerability_assessments_settings:
     ServerVulnerabilityAssessmentsSettingsOperations operations
    :vartype server_vulnerability_assessments_settings:
     azure.mgmt.security.aio.operations.ServerVulnerabilityAssessmentsSettingsOperations
    :ivar api_collections: APICollectionsOperations operations
    :vartype api_collections: azure.mgmt.security.aio.operations.APICollectionsOperations
    :ivar pricings: PricingsOperations operations
    :vartype pricings: azure.mgmt.security.aio.operations.PricingsOperations
    :ivar security_standards: SecurityStandardsOperations operations
    :vartype security_standards: azure.mgmt.security.aio.operations.SecurityStandardsOperations
    :ivar standard_assignments: StandardAssignmentsOperations operations
    :vartype standard_assignments: azure.mgmt.security.aio.operations.StandardAssignmentsOperations
    :ivar custom_recommendations: CustomRecommendationsOperations operations
    :vartype custom_recommendations:
     azure.mgmt.security.aio.operations.CustomRecommendationsOperations
    :ivar azure_dev_ops_orgs: AzureDevOpsOrgsOperations operations
    :vartype azure_dev_ops_orgs: azure.mgmt.security.aio.operations.AzureDevOpsOrgsOperations
    :ivar azure_dev_ops_projects: AzureDevOpsProjectsOperations operations
    :vartype azure_dev_ops_projects:
     azure.mgmt.security.aio.operations.AzureDevOpsProjectsOperations
    :ivar azure_dev_ops_repos: AzureDevOpsReposOperations operations
    :vartype azure_dev_ops_repos: azure.mgmt.security.aio.operations.AzureDevOpsReposOperations
    :ivar dev_ops_configurations: DevOpsConfigurationsOperations operations
    :vartype dev_ops_configurations:
     azure.mgmt.security.aio.operations.DevOpsConfigurationsOperations
    :ivar git_hub_owners: GitHubOwnersOperations operations
    :vartype git_hub_owners: azure.mgmt.security.aio.operations.GitHubOwnersOperations
    :ivar git_hub_repos: GitHubReposOperations operations
    :vartype git_hub_repos: azure.mgmt.security.aio.operations.GitHubReposOperations
    :ivar git_lab_groups: GitLabGroupsOperations operations
    :vartype git_lab_groups: azure.mgmt.security.aio.operations.GitLabGroupsOperations
    :ivar git_lab_subgroups: GitLabSubgroupsOperations operations
    :vartype git_lab_subgroups: azure.mgmt.security.aio.operations.GitLabSubgroupsOperations
    :ivar git_lab_projects: GitLabProjectsOperations operations
    :vartype git_lab_projects: azure.mgmt.security.aio.operations.GitLabProjectsOperations
    :ivar dev_ops_operation_results: DevOpsOperationResultsOperations operations
    :vartype dev_ops_operation_results:
     azure.mgmt.security.aio.operations.DevOpsOperationResultsOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: Azure subscription ID. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is None.
    :type base_url: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self, credential: "AsyncTokenCredential", subscription_id: str, base_url: Optional[str] = None, **kwargs: Any
    ) -> None:
        _cloud = kwargs.pop("cloud_setting", None) or settings.current.azure_cloud  # type: ignore
        _endpoints = get_arm_endpoints(_cloud)
        if not base_url:
            base_url = _endpoints["resource_manager"]
        credential_scopes = kwargs.pop("credential_scopes", _endpoints["credential_scopes"])
        self._config = SecurityCenterConfiguration(
            credential=credential, subscription_id=subscription_id, credential_scopes=credential_scopes, **kwargs
        )

        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                AsyncARMAutoResourceProviderRegistrationPolicy(),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                policies.SensitiveHeaderCleanupPolicy(**kwargs) if self._config.redirect_policy else None,
                self._config.http_logging_policy,
            ]
        self._client: AsyncARMPipelineClient = AsyncARMPipelineClient(
            base_url=cast(str, base_url), policies=_policies, **kwargs
        )

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.locations = LocationsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.tasks = TasksOperations(self._client, self._config, self._serialize, self._deserialize)
        self.auto_provisioning_settings = AutoProvisioningSettingsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.compliances = CompliancesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.information_protection_policies = InformationProtectionPoliciesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workspace_settings = WorkspaceSettingsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.alerts_suppression_rules = AlertsSuppressionRulesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.regulatory_compliance_standards = RegulatoryComplianceStandardsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.regulatory_compliance_controls = RegulatoryComplianceControlsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.regulatory_compliance_assessments = RegulatoryComplianceAssessmentsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.sub_assessments = SubAssessmentsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.connectors = ConnectorsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.software_inventories = SoftwareInventoriesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.custom_assessment_automations = CustomAssessmentAutomationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.custom_entity_store_assignments = CustomEntityStoreAssignmentsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.mde_onboardings = MdeOnboardingsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.governance_assignments = GovernanceAssignmentsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.governance_rules = GovernanceRulesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.applications = ApplicationsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.application = ApplicationOperations(self._client, self._config, self._serialize, self._deserialize)
        self.security_connector_applications = SecurityConnectorApplicationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.security_connector_application = SecurityConnectorApplicationOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.security_operators = SecurityOperatorsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.sql_vulnerability_assessment_baseline_rules = SqlVulnerabilityAssessmentBaselineRulesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.sql_vulnerability_assessment_scans = SqlVulnerabilityAssessmentScansOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.sql_vulnerability_assessment_scan_results = SqlVulnerabilityAssessmentScanResultsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.sensitivity_settings = SensitivitySettingsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.health_reports = HealthReportsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.automations = AutomationsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.security_contacts = SecurityContactsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.security_connectors = SecurityConnectorsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.defender_for_storage = DefenderForStorageOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.assessments_metadata = AssessmentsMetadataOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.assessments = AssessmentsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.private_links = PrivateLinksOperations(self._client, self._config, self._serialize, self._deserialize)
        self.private_link_resources = PrivateLinkResourcesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.private_endpoint_connections = PrivateEndpointConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.compliance_results = ComplianceResultsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.advanced_threat_protection = AdvancedThreatProtectionOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.device_security_groups = DeviceSecurityGroupsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.iot_security_solution_analytics = IotSecuritySolutionAnalyticsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.iot_security_solutions_analytics_aggregated_alert = IotSecuritySolutionsAnalyticsAggregatedAlertOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.iot_security_solutions_analytics_recommendation = IotSecuritySolutionsAnalyticsRecommendationOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.iot_security_solution = IotSecuritySolutionOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.allowed_connections = AllowedConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.discovered_security_solutions = DiscoveredSecuritySolutionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.external_security_solutions = ExternalSecuritySolutionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.jit_network_access_policies = JitNetworkAccessPoliciesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.secure_scores = SecureScoresOperations(self._client, self._config, self._serialize, self._deserialize)
        self.secure_score_controls = SecureScoreControlsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.secure_score_control_definitions = SecureScoreControlDefinitionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.security_solutions = SecuritySolutionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.security_solutions_reference_data = SecuritySolutionsReferenceDataOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.server_vulnerability_assessment = ServerVulnerabilityAssessmentOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.topology = TopologyOperations(self._client, self._config, self._serialize, self._deserialize)
        self.alerts = AlertsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.settings = SettingsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.server_vulnerability_assessments_settings = ServerVulnerabilityAssessmentsSettingsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.api_collections = APICollectionsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.pricings = PricingsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.security_standards = SecurityStandardsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.standard_assignments = StandardAssignmentsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.custom_recommendations = CustomRecommendationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.azure_dev_ops_orgs = AzureDevOpsOrgsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.azure_dev_ops_projects = AzureDevOpsProjectsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.azure_dev_ops_repos = AzureDevOpsReposOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.dev_ops_configurations = DevOpsConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.git_hub_owners = GitHubOwnersOperations(self._client, self._config, self._serialize, self._deserialize)
        self.git_hub_repos = GitHubReposOperations(self._client, self._config, self._serialize, self._deserialize)
        self.git_lab_groups = GitLabGroupsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.git_lab_subgroups = GitLabSubgroupsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.git_lab_projects = GitLabProjectsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.dev_ops_operation_results = DevOpsOperationResultsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )

    def _send_request(
        self, request: HttpRequest, *, stream: bool = False, **kwargs: Any
    ) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client._send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, stream=stream, **kwargs)  # type: ignore

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> Self:
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details: Any) -> None:
        await self._client.__aexit__(*exc_details)
