// SPDX-FileCopyrightText: Copyright (c) Kitware Inc.
// SPDX-License-Identifier: BSD-3-Clause
// .NAME vtkMyElevationFilter - generate scalars along a specified direction
// .SECTION Description
// vtkMyElevationFilter is a filter to generate scalar values from a
// dataset.  The scalar values lie within a user specified range, and
// are generated by computing a projection of each dataset point onto
// a line. The line can be oriented arbitrarily. A typical example is
// to generate scalars based on elevation or height above a plane.

#ifndef vtkMyElevationFilter_h
#define vtkMyElevationFilter_h

#include <vtkElevationFilter.h>

#include "ElevationFiltersModule.h" // for export macro

class ELEVATIONFILTERS_EXPORT vtkMyElevationFilter : public vtkElevationFilter
{
public:
  static vtkMyElevationFilter* New();
  vtkTypeMacro(vtkMyElevationFilter, vtkElevationFilter);
  void PrintSelf(ostream& os, vtkIndent indent) override;

protected:
  vtkMyElevationFilter();
  ~vtkMyElevationFilter();

private:
  vtkMyElevationFilter(const vtkMyElevationFilter&) = delete;
  void operator=(const vtkMyElevationFilter&) = delete;
};

#endif
