## Mailing list

We have a [GitHub discussions](https://github.com/OpenMathLib/OpenBLAS/discussions/) forum to discuss usage and development of OpenBLAS. We also have a [Google group for *users*](https://groups.google.com/forum/#!forum/openblas-users) and a [Google group for *development of*](https://groups.google.com/forum/#!forum/openblas-dev) OpenBLAS. 

## Acknowledgements

This work was or is partially supported by the following grants, contracts and institutions:

* Research and Development of Compiler System and Toolchain for Domestic CPU, National S&T Major Projects: Core Electronic Devices, High-end General Chips and Fundamental Software (No.2009ZX01036-001-002)
* National High-tech R&D Program of China (Grant No.2012AA010903)
* [PerfXLab](http://www.perfxlab.com/)
* Chan Zuckerberg Initiative's Essential Open Source Software for Science program:
    * Cycle 1 grant: [Strengthening NumPy's foundations - growing beyond code](https://figshare.com/articles/journal_contribution/Proposal_NumPy_OpenBLAS_for_Chan_Zuckerberg_Initiative_EOSS_2019_round_1/10302167) (2019-2020)
    * Cycle 3 grant: [Improving usability and sustainability for NumPy and OpenBLAS](https://chanzuckerberg.com/eoss/proposals/improving-usability-and-sustainability-for-numpy-and-openblas/) (2020-2021)
* Sovereign Tech Fund funding: [Keeping high performance linear algebra computation accessible and open for all](https://www.sovereigntechfund.de/tech/openblas) (2023-2024)

Over the course of OpenBLAS development, a number of donations were received.
You can read OpenBLAS's statement of receipts and disbursement and cash balance in
[this Google doc](https://docs.google.com/spreadsheet/ccc?key=0AghkTjXe2lDndE1UZml0dGpaUzJmZGhvenBZd1F2R1E&usp=sharing) (covers 2013-2016).
A list of backers is available [in BACKERS.md](https://github.com/OpenMathLib/OpenBLAS/blob/develop/BACKERS.md) in the main repo.

### Donations

We welcome hardware donations, including the latest CPUs and motherboards.


## Open source users of OpenBLAS

Prominent open source users of OpenBLAS include:

* [Julia](https://julialang.org) - a high-level, high-performance dynamic programming language for technical computing
* [NumPy](https://numpy.org) - the fundamental package for scientific computing with Python
* [SciPy](https://scipy.org) - fundamental algorithms for scientific computing in Python
* [R](https://www.r-project.org/) - a free software environment for statistical computing and graphics
* [OpenCV](https://opencv.org/) - the world's biggest computer vision library

OpenBLAS is packaged in most major Linux distros, as well as general and
numerical computing-focused packaging ecosystems like Nix, Homebrew, Spack and
conda-forge.

OpenBLAS is used directly by libraries written in C, C++ and Fortran (and
probably other languages), and directly by end users in those languages.


## Publications

### 2013

* Wang Qian, Zhang Xianyi, Zhang Yunquan, Qing Yi,  **AUGEM: Automatically Generate High Performance Dense Linear Algebra Kernels on x86 CPUs**, In the International Conference for High Performance Computing, Networking, Storage and Analysis (SC'13), Denver CO, November 2013. [[pdf](http://xianyi.github.io/paper/augem_SC13.pdf)]

### 2012

* Zhang Xianyi, Wang Qian, Zhang Yunquan, **Model-driven Level 3 BLAS Performance Optimization on Loongson 3A Processor**, 2012 IEEE 18th International Conference on Parallel and Distributed Systems (ICPADS), 17-19 Dec. 2012.
