find_package(PkgConfig)
if (PKG_CONFIG_FOUND)
    if (Minizip_FIND_REQUIRED)
        set(_pkgconfig_REQUIRED REQUIRED)
    endif ()
    pkg_check_modules(Minizip ${_pkgconfig_REQUIRED} minizip)
    if (Minizip_LINK_LIBRARIES)
        set(Minizip_LIBRARIES ${Minizip_LINK_LIBRARIES}) # HACK
    endif ()
else ()
    find_path(Minizip_INCLUDE_DIRS unzip.h)
    # find_library(Minizip_LIBRARIES)
    if (Minizip_INCLUDE_DIRS AND Minizip_LIBRARIES)
        set(Minizip_FOUND 1)
        if (NOT Minizip_FIND_QUIETLY)
            message(STATUS "Found Minizip: ${Minizip_LIBRARIES}")
        endif ()
    elseif (Minizip_FIND_REQUIRED)
        message(SEND_ERROR "Could not find Minizip")
    elseif (NOT Minizip_FIND_QUIETLY)
        message(STATUS "Could not find Minizip")
    endif ()
endif ()
mark_as_advanced(Minizip_INCLUDE_DIRS Minizip_LIBRARIES)
