; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
;=========================== begin_copyright_notice ============================
;
; Copyright (C) 2025 Intel Corporation
;
; SPDX-License-Identifier: MIT
;
;============================ end_copyright_notice =============================

; REQUIRES: regkeys
; RUN: igc_opt -S --igc-split-loads -platformpvc --regkey=LS_enableLoadSplitting=1 --regkey=LS_ignoreSplitThreshold=1 --regkey=LS_minSplitSize_GRF=0 --regkey=LS_minSplitSize_E=0 %s | FileCheck %s --check-prefix=SPLIT
; RUN: igc_opt -S --igc-split-loads -platformpvc --regkey=LS_enableLoadSplitting=1 --regkey=LS_ignoreSplitThreshold=1 --regkey=LS_minSplitSize_GRF=100 --regkey=LS_minSplitSize_E=0 %s | FileCheck %s --check-prefix=GRF
; RUN: igc_opt -S --igc-split-loads -platformpvc --regkey=LS_enableLoadSplitting=1 --regkey=LS_ignoreSplitThreshold=1 --regkey=LS_minSplitSize_GRF=0 --regkey=LS_minSplitSize_E=4 %s | FileCheck %s --check-prefix=ELTS4
; RUN: igc_opt -S --igc-split-loads -platformpvc --regkey=LS_enableLoadSplitting=1 --regkey=LS_ignoreSplitThreshold=1 --regkey=LS_minSplitSize_GRF=0 --regkey=LS_minSplitSize_E=8 %s | FileCheck %s --check-prefix=ELTS8
; RUN: igc_opt -S --igc-split-loads -platformpvc --regkey=LS_enableLoadSplitting=1 --regkey=LS_ignoreSplitThreshold=1 --regkey=LS_minSplitSize_GRF=0 --regkey=LS_minSplitSize_E=16 %s | FileCheck %s --check-prefix=ELTS16
; RUN: igc_opt -S --igc-split-loads -platformpvc --regkey=LS_enableLoadSplitting=1 --regkey=LS_ignoreSplitThreshold=0 --regkey=LS_splitThresholdDelta_GRF=-1000 %s | FileCheck %s --check-prefix=THRESHOLD

declare spir_func void @fun_v4i32(<4 x i32>)

declare spir_func <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64, i32, i32, i32, i32, i32, i32, i32, i32, i32, i1, i1, i32)

define spir_kernel void @test_threshold(i64 %ptr) {
; SPLIT-LABEL: @test_threshold(
; SPLIT-NEXT:    [[TMP1:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; SPLIT-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 4, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; SPLIT-NEXT:    [[TMP3:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 8, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; SPLIT-NEXT:    [[TMP4:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 12, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; SPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP1]])
; SPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP2]])
; SPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP3]])
; SPLIT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP4]])
; SPLIT-NEXT:    ret void
;
; GRF-LABEL: @test_threshold(
; GRF-NEXT:    [[VEC1:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
; GRF-NEXT:    [[PICK1_1:%.*]] = shufflevector <16 x i32> [[VEC1]], <16 x i32> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; GRF-NEXT:    [[PICK1_2:%.*]] = shufflevector <16 x i32> [[VEC1]], <16 x i32> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
; GRF-NEXT:    [[PICK1_3:%.*]] = shufflevector <16 x i32> [[VEC1]], <16 x i32> undef, <4 x i32> <i32 8, i32 9, i32 10, i32 11>
; GRF-NEXT:    [[PICK1_4:%.*]] = shufflevector <16 x i32> [[VEC1]], <16 x i32> undef, <4 x i32> <i32 12, i32 13, i32 14, i32 15>
; GRF-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK1_1]])
; GRF-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK1_2]])
; GRF-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK1_3]])
; GRF-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK1_4]])
; GRF-NEXT:    ret void
;
; ELTS4-LABEL: @test_threshold(
; ELTS4-NEXT:    [[TMP1:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; ELTS4-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 4, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; ELTS4-NEXT:    [[TMP3:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 8, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; ELTS4-NEXT:    [[TMP4:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 12, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; ELTS4-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP1]])
; ELTS4-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP2]])
; ELTS4-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP3]])
; ELTS4-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP4]])
; ELTS4-NEXT:    ret void
;
; ELTS8-LABEL: @test_threshold(
; ELTS8-NEXT:    [[TMP1:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 8, i32 1, i1 false, i1 false, i32 0)
; ELTS8-NEXT:    [[TMP2:%.*]] = extractelement <8 x i32> [[TMP1]], i64 0
; ELTS8-NEXT:    [[TMP3:%.*]] = insertelement <4 x i32> undef, i32 [[TMP2]], i64 0
; ELTS8-NEXT:    [[TMP4:%.*]] = extractelement <8 x i32> [[TMP1]], i64 1
; ELTS8-NEXT:    [[TMP5:%.*]] = insertelement <4 x i32> [[TMP3]], i32 [[TMP4]], i64 1
; ELTS8-NEXT:    [[TMP6:%.*]] = extractelement <8 x i32> [[TMP1]], i64 2
; ELTS8-NEXT:    [[TMP7:%.*]] = insertelement <4 x i32> [[TMP5]], i32 [[TMP6]], i64 2
; ELTS8-NEXT:    [[TMP8:%.*]] = extractelement <8 x i32> [[TMP1]], i64 3
; ELTS8-NEXT:    [[TMP9:%.*]] = insertelement <4 x i32> [[TMP7]], i32 [[TMP8]], i64 3
; ELTS8-NEXT:    [[TMP10:%.*]] = extractelement <8 x i32> [[TMP1]], i64 4
; ELTS8-NEXT:    [[TMP11:%.*]] = insertelement <4 x i32> undef, i32 [[TMP10]], i64 0
; ELTS8-NEXT:    [[TMP12:%.*]] = extractelement <8 x i32> [[TMP1]], i64 5
; ELTS8-NEXT:    [[TMP13:%.*]] = insertelement <4 x i32> [[TMP11]], i32 [[TMP12]], i64 1
; ELTS8-NEXT:    [[TMP14:%.*]] = extractelement <8 x i32> [[TMP1]], i64 6
; ELTS8-NEXT:    [[TMP15:%.*]] = insertelement <4 x i32> [[TMP13]], i32 [[TMP14]], i64 2
; ELTS8-NEXT:    [[TMP16:%.*]] = extractelement <8 x i32> [[TMP1]], i64 7
; ELTS8-NEXT:    [[TMP17:%.*]] = insertelement <4 x i32> [[TMP15]], i32 [[TMP16]], i64 3
; ELTS8-NEXT:    [[TMP18:%.*]] = call <8 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v8i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 8, i32 32, i32 16, i32 8, i32 1, i1 false, i1 false, i32 0)
; ELTS8-NEXT:    [[TMP19:%.*]] = extractelement <8 x i32> [[TMP18]], i64 0
; ELTS8-NEXT:    [[TMP20:%.*]] = insertelement <4 x i32> undef, i32 [[TMP19]], i64 0
; ELTS8-NEXT:    [[TMP21:%.*]] = extractelement <8 x i32> [[TMP18]], i64 1
; ELTS8-NEXT:    [[TMP22:%.*]] = insertelement <4 x i32> [[TMP20]], i32 [[TMP21]], i64 1
; ELTS8-NEXT:    [[TMP23:%.*]] = extractelement <8 x i32> [[TMP18]], i64 2
; ELTS8-NEXT:    [[TMP24:%.*]] = insertelement <4 x i32> [[TMP22]], i32 [[TMP23]], i64 2
; ELTS8-NEXT:    [[TMP25:%.*]] = extractelement <8 x i32> [[TMP18]], i64 3
; ELTS8-NEXT:    [[TMP26:%.*]] = insertelement <4 x i32> [[TMP24]], i32 [[TMP25]], i64 3
; ELTS8-NEXT:    [[TMP27:%.*]] = extractelement <8 x i32> [[TMP18]], i64 4
; ELTS8-NEXT:    [[TMP28:%.*]] = insertelement <4 x i32> undef, i32 [[TMP27]], i64 0
; ELTS8-NEXT:    [[TMP29:%.*]] = extractelement <8 x i32> [[TMP18]], i64 5
; ELTS8-NEXT:    [[TMP30:%.*]] = insertelement <4 x i32> [[TMP28]], i32 [[TMP29]], i64 1
; ELTS8-NEXT:    [[TMP31:%.*]] = extractelement <8 x i32> [[TMP18]], i64 6
; ELTS8-NEXT:    [[TMP32:%.*]] = insertelement <4 x i32> [[TMP30]], i32 [[TMP31]], i64 2
; ELTS8-NEXT:    [[TMP33:%.*]] = extractelement <8 x i32> [[TMP18]], i64 7
; ELTS8-NEXT:    [[TMP34:%.*]] = insertelement <4 x i32> [[TMP32]], i32 [[TMP33]], i64 3
; ELTS8-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP9]])
; ELTS8-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP17]])
; ELTS8-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP26]])
; ELTS8-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP34]])
; ELTS8-NEXT:    ret void
;
; ELTS16-LABEL: @test_threshold(
; ELTS16-NEXT:    [[VEC1:%.*]] = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
; ELTS16-NEXT:    [[PICK1_1:%.*]] = shufflevector <16 x i32> [[VEC1]], <16 x i32> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
; ELTS16-NEXT:    [[PICK1_2:%.*]] = shufflevector <16 x i32> [[VEC1]], <16 x i32> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
; ELTS16-NEXT:    [[PICK1_3:%.*]] = shufflevector <16 x i32> [[VEC1]], <16 x i32> undef, <4 x i32> <i32 8, i32 9, i32 10, i32 11>
; ELTS16-NEXT:    [[PICK1_4:%.*]] = shufflevector <16 x i32> [[VEC1]], <16 x i32> undef, <4 x i32> <i32 12, i32 13, i32 14, i32 15>
; ELTS16-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK1_1]])
; ELTS16-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK1_2]])
; ELTS16-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK1_3]])
; ELTS16-NEXT:    call void @fun_v4i32(<4 x i32> [[PICK1_4]])
; ELTS16-NEXT:    ret void
;
; THRESHOLD-LABEL: @test_threshold(
; THRESHOLD-NEXT:    [[TMP1:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; THRESHOLD-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 4, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; THRESHOLD-NEXT:    [[TMP3:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 8, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; THRESHOLD-NEXT:    [[TMP4:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 12, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; THRESHOLD-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP1]])
; THRESHOLD-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP2]])
; THRESHOLD-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP3]])
; THRESHOLD-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP4]])
; THRESHOLD-NEXT:    ret void
;
; DEFAULT-LABEL: @test_threshold(
; DEFAULT-NEXT:    [[TMP1:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR:%.*]], i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; DEFAULT-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 4, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; DEFAULT-NEXT:    [[TMP3:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 8, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; DEFAULT-NEXT:    [[TMP4:%.*]] = call <4 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v4i32(i64 [[PTR]], i32 127, i32 63, i32 127, i32 0, i32 12, i32 32, i32 16, i32 4, i32 1, i1 false, i1 false, i32 0)
; DEFAULT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP1]])
; DEFAULT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP2]])
; DEFAULT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP3]])
; DEFAULT-NEXT:    call void @fun_v4i32(<4 x i32> [[TMP4]])
; DEFAULT-NEXT:    ret void
  %vec1 = call <16 x i32> @llvm.genx.GenISA.LSC2DBlockRead.v16i32(i64 %ptr, i32 127, i32 63, i32 127, i32 0, i32 0, i32 32, i32 16, i32 16, i32 1, i1 false, i1 false, i32 0)
  %pick1.1 = shufflevector <16 x i32> %vec1, <16 x i32> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %pick1.2 = shufflevector <16 x i32> %vec1, <16 x i32> undef, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %pick1.3 = shufflevector <16 x i32> %vec1, <16 x i32> undef, <4 x i32> <i32 8, i32 9, i32 10, i32 11>
  %pick1.4 = shufflevector <16 x i32> %vec1, <16 x i32> undef, <4 x i32> <i32 12, i32 13, i32 14, i32 15>
  call void @fun_v4i32(<4 x i32> %pick1.1)
  call void @fun_v4i32(<4 x i32> %pick1.2)
  call void @fun_v4i32(<4 x i32> %pick1.3)
  call void @fun_v4i32(<4 x i32> %pick1.4)
  ret void
}
