/* SPDX-License-Identifier: GPL-2.0 */
/*
 * TI DP83869 PHY drivers
 *
 */

#ifndef _DT_BINDINGS_TI_DP83869_H
#define _DT_BINDINGS_TI_DP83869_H

/* PHY CTRL bits */
#define DP83869_PHYCR_FIFO_DEPTH_3_B_NIB	0x00
#define DP83869_PHYCR_FIFO_DEPTH_4_B_NIB	0x01
#define DP83869_PHYCR_FIFO_DEPTH_6_B_NIB	0x02
#define DP83869_PHYCR_FIFO_DEPTH_8_B_NIB	0x03

/* RGMIIDCTL internal delay for rx and tx */
#define DP83869_RGMIIDCTL_250_PS	0x0
#define DP83869_RGMIIDCTL_500_PS	0x1
#define DP83869_RGMIIDCTL_750_PS	0x2
#define DP83869_RGMIIDCTL_1_NS		0x3
#define DP83869_RGMIIDCTL_1_25_NS	0x4
#define DP83869_RGMIIDCTL_1_50_NS	0x5
#define DP83869_RGMIIDCTL_1_75_NS	0x6
#define DP83869_RGMIIDCTL_2_00_NS	0x7
#define DP83869_RGMIIDCTL_2_25_NS	0x8
#define DP83869_RGMIIDCTL_2_50_NS	0x9
#define DP83869_RGMIIDCTL_2_75_NS	0xa
#define DP83869_RGMIIDCTL_3_00_NS	0xb
#define DP83869_RGMIIDCTL_3_25_NS	0xc
#define DP83869_RGMIIDCTL_3_50_NS	0xd
#define DP83869_RGMIIDCTL_3_75_NS	0xe
#define DP83869_RGMIIDCTL_4_00_NS	0xf

/* IO_MUX_CFG - Clock output selection */
#define DP83869_CLK_O_SEL_CHN_A_RCLK		0x0
#define DP83869_CLK_O_SEL_CHN_B_RCLK		0x1
#define DP83869_CLK_O_SEL_CHN_C_RCLK		0x2
#define DP83869_CLK_O_SEL_CHN_D_RCLK		0x3
#define DP83869_CLK_O_SEL_CHN_A_RCLK_DIV5	0x4
#define DP83869_CLK_O_SEL_CHN_B_RCLK_DIV5	0x5
#define DP83869_CLK_O_SEL_CHN_C_RCLK_DIV5	0x6
#define DP83869_CLK_O_SEL_CHN_D_RCLK_DIV5	0x7
#define DP83869_CLK_O_SEL_CHN_A_TCLK		0x8
#define DP83869_CLK_O_SEL_CHN_B_TCLK		0x9
#define DP83869_CLK_O_SEL_CHN_C_TCLK		0xA
#define DP83869_CLK_O_SEL_CHN_D_TCLK		0xB
#define DP83869_CLK_O_SEL_REF_CLK		0xC
/* Special flag to indicate clock should be off */
#define DP83869_CLK_O_SEL_OFF			0xFFFFFFFF

/* OPMODE - Operation mode */
#define DP83869_RGMII_COPPER_ETHERNET		0x00
#define DP83869_RGMII_1000_BASE			0x01
#define DP83869_RGMII_100_BASE			0x02
#define DP83869_RGMII_SGMII_BRIDGE		0x03
#define DP83869_1000M_MEDIA_CONVERT		0x04
#define DP83869_100M_MEDIA_CONVERT		0x05
#define DP83869_SGMII_COPPER_ETHERNET		0x06

#endif
